/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.service;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.bc.ftp.FTPUtil;
import org.ow2.petals.bc.ftp.MissingElementException;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClient;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FTPService {
    private final Logger logger;

    public FTPService(Logger logger) {
        this.logger = logger;
    }

    public void processDel(Exchange exchange, Document document, WrappedFTPClient wrappedFTPClient) throws MessagingException, MissingElementException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process DEL operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("del", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        Node node = XMLHelper.findChild((Node)document.getFirstChild(), null, (String)"filename", (boolean)false);
        String string = null;
        if (node == null) {
            throw new MissingElementException("filename");
        }
        string = node.getTextContent();
        if (string != null) {
            try {
                wrappedFTPClient.del(string);
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Can not delete file on FTP server [");
                stringBuilder.append(wrappedFTPClient.getConnectionInfo().getServer());
                stringBuilder.append("] : IOException : ");
                stringBuilder.append(iOException.getMessage());
                throw new MessagingException(stringBuilder.toString());
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("DEL operation ended");
            }
        }
    }

    public void processDir(Exchange exchange, WrappedFTPClient wrappedFTPClient) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process DIR operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("dir", Message.MEPConstants.IN_OUT_PATTERN));
        }
        try {
            List<String> list = wrappedFTPClient.listFolderContent();
            String string = FTPUtil.generateFileNameList(list, exchange.getOperation());
            exchange.getOutMessage().setContent(SourceUtil.createSource((String)string));
        }
        catch (IOException iOException) {
            FTPUtil.setIOFaultOnExchange(exchange, "Can not list files on FTP server [" + wrappedFTPClient.getConnectionInfo().getServer() + "]. Cause : " + iOException.getMessage());
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MessagingException((Throwable)pEtALSCDKException);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("DIR operation ended");
        }
    }

    public void processGet(Exchange exchange, Document document, WrappedFTPClient wrappedFTPClient) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process GET operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("get", Message.MEPConstants.IN_OUT_PATTERN));
        }
        Node node = XMLHelper.findChild((Node)document.getFirstChild(), null, (String)"filename", (boolean)false);
        String string = null;
        if (node != null) {
            string = node.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(string)) {
            FTPUtil.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            try {
                Document document2 = wrappedFTPClient.get(string);
                Element element = document2.createElementNS(exchange.getOperation().getNamespaceURI(), "ver:getResponse");
                element.appendChild(document2.getDocumentElement());
                document2.appendChild(element);
                exchange.setOutMessageContent(document2);
                if (wrappedFTPClient.getConnectionInfo().getDeleteProcessedFile()) {
                    wrappedFTPClient.del(string);
                }
            }
            catch (IOException iOException) {
                FTPUtil.setIOFaultOnExchange(exchange, "Can not get file [" + string + "] on FTP server [" + wrappedFTPClient.getConnectionInfo().getServer() + "]. Cause : " + iOException.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("GET operation ended");
        }
    }

    public void processGetAsAttachment(Exchange exchange, Document document, WrappedFTPClient wrappedFTPClient) throws MessagingException {
        this.logger.info("JBI exchange received - Process GET AS ATTACHMENT operation");
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("getAsAttachment", Message.MEPConstants.IN_OUT_PATTERN));
        }
        Node node = XMLHelper.findChild((Node)document.getFirstChild(), null, (String)"filename", (boolean)true);
        String string = null;
        if (node != null) {
            string = node.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(string)) {
            FTPUtil.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            try {
                DataHandler dataHandler = wrappedFTPClient.getFileAsAttachment(string);
                exchange.setOutMessageAttachment(dataHandler.getName(), dataHandler);
                Document document2 = FTPUtil.generateMTOMResponse(dataHandler.getName(), exchange.getOperation());
                exchange.setOutMessageContent(document2);
                if (wrappedFTPClient.getConnectionInfo().getDeleteProcessedFile()) {
                    wrappedFTPClient.del(dataHandler.getName());
                }
            }
            catch (IOException iOException) {
                FTPUtil.setIOFaultOnExchange(exchange, "Can not get file [" + string + "] on FTP server [" + wrappedFTPClient.getConnectionInfo().getServer() + "]. Cause : " + iOException.getMessage());
            }
        }
        this.logger.info("GET AS ATTACHMENT operation ended");
    }

    public void processMGet(Exchange exchange, Document document, WrappedFTPClient wrappedFTPClient) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process MGET operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("mget", Message.MEPConstants.IN_OUT_PATTERN));
        }
        NodeList nodeList = document.getFirstChild().getChildNodes();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!"filename".equalsIgnoreCase(nodeList.item(i).getLocalName())) continue;
            linkedList.add(nodeList.item(i).getTextContent());
        }
        if (linkedList.size() == 0) {
            FTPUtil.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            try {
                Map<String, DataHandler> map = wrappedFTPClient.mGet(linkedList);
                for (Map.Entry<String, DataHandler> object2 : map.entrySet()) {
                    exchange.getOutMessage().addAttachment(object2.getKey(), object2.getValue());
                }
                LinkedList<String> linkedList2 = new LinkedList<String>(map.keySet());
                Document document2 = FTPUtil.generateMTOMListResponse((List<String>)linkedList2, exchange.getOperation());
                exchange.setOutMessageContent(document2);
                if (wrappedFTPClient.getConnectionInfo().getDeleteProcessedFile()) {
                    wrappedFTPClient.mDel((List<String>)linkedList2);
                }
            }
            catch (IOException iOException) {
                FTPUtil.setIOFaultOnExchange(exchange, "Can not get files [" + linkedList + "] on FTP server [" + wrappedFTPClient.getConnectionInfo().getServer() + "]. Cause : " + iOException.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("MGET operation ended");
        }
    }

    public void processMPut(Exchange exchange, Document document, WrappedFTPClient wrappedFTPClient) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process MPUT operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("mput", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        if (exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("One or more attachments expected.");
            throw new MessagingException(stringBuilder.toString());
        }
        try {
            MtomUtil.MtomMapping mtomMapping = MtomUtil.getMtomMapping((Exchange)exchange, (Element)document.getDocumentElement());
            Map map = mtomMapping.getContentIdToDataHandler();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(mtomMapping.toString());
            }
            wrappedFTPClient.mPut(map);
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can not put files on FTP server [");
            stringBuilder.append(wrappedFTPClient.getConnectionInfo().getServer());
            stringBuilder.append("] : IOException : ");
            stringBuilder.append(iOException.getMessage());
            throw new MessagingException(stringBuilder.toString());
        }
        this.logger.info("MPUT operation ended");
    }

    public void processPut(Exchange exchange, Document document, WrappedFTPClient wrappedFTPClient) throws MessagingException, MissingElementException {
        if (exchange == null) {
            throw new MessagingException("exchange parameter is null");
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process PUT operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("put", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        Node node = document.getFirstChild();
        if (node == null || !"put".equalsIgnoreCase(node.getLocalName())) {
            throw new MissingElementException("put");
        }
        Node node2 = XMLHelper.findChild((Node)node, null, (String)"filename", (boolean)false);
        if (node2 == null || !"filename".equalsIgnoreCase(node2.getLocalName())) {
            throw new MissingElementException("filename");
        }
        Node node3 = XMLHelper.findChild((Node)node, null, (String)"body", (boolean)false);
        if (node3 == null) {
            throw new MissingElementException("body");
        }
        try {
            String string = XMLHelper.toString((NodeList)node3.getChildNodes());
            wrappedFTPClient.putString(node2.getTextContent(), string);
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can not put XML content on FTP server [");
            stringBuilder.append(wrappedFTPClient.getConnectionInfo().getServer());
            stringBuilder.append("] : IOException : ");
            stringBuilder.append(iOException.getMessage());
            throw new MessagingException(stringBuilder.toString());
        }
        catch (DOMException dOMException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can not put XML content on FTP server [");
            stringBuilder.append(wrappedFTPClient.getConnectionInfo().getServer());
            stringBuilder.append("] : DOMException : ");
            stringBuilder.append(dOMException.getMessage());
            throw new MessagingException(stringBuilder.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("PUT operation ended");
        }
    }
}

