/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.connection;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClient;

public class WrappedFTPClientFactory
implements PoolableObjectFactory {
    final FTPConnectionInfo connectionConfiguration;
    final Logger logger;

    public WrappedFTPClientFactory(FTPConnectionInfo connectionConfiguration, Logger logger) {
        this.logger = logger;
        this.connectionConfiguration = connectionConfiguration;
    }

    public Object makeObject() throws Exception {
        this.logger.finest("Create new instance of FTPClient");
        WrappedFTPClient client = new WrappedFTPClient(this.connectionConfiguration, this.logger);
        try {
            client.connectAndLog();
            client.configureConnection();
        }
        catch (IOException e) {
            this.destroyObject((Object)client);
            throw e;
        }
        return client;
    }

    public void destroyObject(Object obj) throws Exception {
        WrappedFTPClient client = (WrappedFTPClient)((Object)obj);
        if (client != null && client.isConnected()) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Log out user and disconnect FTP connection : [" + this.connectionConfiguration.toString() + "]");
            }
            client.logout();
            client.disconnect();
        }
    }

    public boolean validateObject(Object obj) {
        this.logger.finest("Validate instance of FTPClientWrapped");
        WrappedFTPClient client = (WrappedFTPClient)((Object)obj);
        Boolean result = false;
        try {
            if (client.isConnected() && client.sendNoOp()) {
                this.logger.finest("FTPClient is connected");
                result = true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void passivateObject(Object obj) throws Exception {
    }
}

