/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Whitespace;

public final class YearMonthDurationValue
extends DurationValue
implements Comparable {
    private YearMonthDurationValue() {
        this.typeLabel = BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    public static ConversionResult makeYearMonthDurationValue(CharSequence s) {
        int years = 0;
        int months = 0;
        boolean negative = false;
        int components = 0;
        StringTokenizer tok = new StringTokenizer(((Object)Whitespace.trimWhitespace(s)).toString(), "-+PYM", true);
        if (!tok.hasMoreElements()) {
            return YearMonthDurationValue.badDuration("empty string", s);
        }
        String part = (String)tok.nextElement();
        if ("+".equals(part)) {
            return YearMonthDurationValue.badDuration("+ sign not allowed in a duration", s);
        }
        if ("-".equals(part)) {
            negative = true;
            part = (String)tok.nextElement();
        }
        if (!"P".equals(part)) {
            return YearMonthDurationValue.badDuration("missing 'P'", s);
        }
        int state = 0;
        block4: while (tok.hasMoreElements()) {
            part = (String)tok.nextElement();
            int value = YearMonthDurationValue.simpleInteger(part);
            if (value < 0) {
                return YearMonthDurationValue.badDuration("non-numeric component", s);
            }
            if (!tok.hasMoreElements()) {
                return YearMonthDurationValue.badDuration("missing unit letter at end", s);
            }
            char delim = ((String)tok.nextElement()).charAt(0);
            switch (delim) {
                case 'Y': {
                    if (state > 0) {
                        return YearMonthDurationValue.badDuration("Y is out of sequence", s);
                    }
                    years = value;
                    ++components;
                    state = 1;
                    continue block4;
                }
                case 'M': {
                    if (state == 0 || state == 1) {
                        months = value;
                        ++components;
                        state = 2;
                        continue block4;
                    }
                    return YearMonthDurationValue.badDuration("M is out of sequence", s);
                }
            }
            return YearMonthDurationValue.badDuration("misplaced " + delim, s);
        }
        if (components == 0) {
            return YearMonthDurationValue.badDuration("duration specifies no components", s);
        }
        if ((long)years + (long)months * 12L > Integer.MAX_VALUE) {
            return YearMonthDurationValue.badDuration("duration exceeds limits", s);
        }
        return YearMonthDurationValue.fromMonths((years * 12 + months) * (negative ? -1 : 1));
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        YearMonthDurationValue v = YearMonthDurationValue.fromMonths(this.getLengthInMonths());
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    public CharSequence getPrimitiveStringValue() {
        int y = this.getYears();
        int m = this.getMonths();
        FastStringBuffer sb = new FastStringBuffer(32);
        if (this.negative) {
            sb.append('-');
        }
        sb.append('P');
        if (y != 0) {
            sb.append(y + "Y");
        }
        if (m != 0 || y == 0) {
            sb.append(m + "M");
        }
        return sb;
    }

    public int getLengthInMonths() {
        return this.months * (this.negative ? -1 : 1);
    }

    public static YearMonthDurationValue fromMonths(int months) {
        YearMonthDurationValue mdv = new YearMonthDurationValue();
        mdv.negative = months < 0;
        mdv.months = months < 0 ? -months : months;
        mdv.seconds = 0L;
        mdv.microseconds = 0;
        return mdv;
    }

    public DurationValue multiply(double n) throws XPathException {
        if (Double.isNaN(n)) {
            XPathException err = new XPathException("Cannot multiply/divide a duration by NaN");
            err.setErrorCode("FOCA0005");
            throw err;
        }
        double m = this.getLengthInMonths();
        double product = n * m;
        if (Double.isInfinite(product) || product > 2.147483647E9 || product < -2.147483648E9) {
            XPathException err = new XPathException("Overflow when multiplying/dividing a duration by a number");
            err.setErrorCode("FODT0002");
            throw err;
        }
        return YearMonthDurationValue.fromMonths((int)Math.round(product));
    }

    public DecimalValue divide(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            BigDecimal v1 = BigDecimal.valueOf(this.getLengthInMonths());
            BigDecimal v2 = BigDecimal.valueOf(((YearMonthDurationValue)other).getLengthInMonths());
            if (v2.signum() == 0) {
                XPathException err = new XPathException("Divide by zero (durations)");
                err.setErrorCode("FOAR0001");
                throw err;
            }
            return new DecimalValue(v1.divide(v2, 20, 6));
        }
        XPathException err = new XPathException("Cannot divide two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public DurationValue add(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() + ((YearMonthDurationValue)other).getLengthInMonths());
        }
        XPathException err = new XPathException("Cannot add two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public DurationValue subtract(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() - ((YearMonthDurationValue)other).getLengthInMonths());
        }
        XPathException err = new XPathException("Cannot subtract two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public DurationValue negate() {
        return YearMonthDurationValue.fromMonths(-this.getLengthInMonths());
    }

    public int compareTo(Object other) {
        if (other instanceof YearMonthDurationValue) {
            return this.getLengthInMonths() - ((YearMonthDurationValue)other).getLengthInMonths();
        }
        throw new ClassCastException("Cannot compare a yearMonthDuration to an object of class " + other.getClass());
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return this;
    }
}

