/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.connection;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.component.framework.util.FileNamePatternUtil;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WrappedFTPClient
extends FTPClient {
    private final FTPConnectionInfo connectionInfo;
    private final transient Logger logger;

    public WrappedFTPClient(FTPConnectionInfo connectionInfo, Logger logger) {
        this.connectionInfo = connectionInfo;
        this.logger = logger;
    }

    public void configureConnection() throws IOException {
        boolean cd = true;
        if (!StringHelper.isNullOrEmpty((String)this.connectionInfo.getDirectory())) {
            cd = this.changeWorkingDirectory(this.connectionInfo.getDirectory());
        }
        if (!cd) {
            throw new IOException("Failed to change directory. Target directory : [" + this.connectionInfo.getDirectory() + "]");
        }
        this.logger.finest("FTP server working directory is : " + this.printWorkingDirectory());
        if (this.connectionInfo.isPassiveMode()) {
            this.enterLocalPassiveMode();
            this.logger.finest("enter Passive mode");
        }
        if (this.connectionInfo.isAsciiTransferType()) {
            this.setFileType(0);
            this.logger.finest("ascii transfer mode enable");
        } else if (this.connectionInfo.isBinaryTransferType()) {
            this.setFileType(2);
            this.logger.finest("binary transfer mode enable");
        }
    }

    public void del(String remoteFile) throws IOException {
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        boolean deleted = false;
        while (!deleted) {
            if (++numberOfTries > maxTries) {
                throw new IOException("Error occurred while deleting '" + remoteFile + "' file from the FTP server");
            }
            try {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start deleting '" + remoteFile + "' file from the FTP server");
                }
                deleted = this.deleteFile(remoteFile);
            }
            catch (IOException e) {
                if (numberOfTries == maxTries) {
                    throw e;
                }
                this.logger.warning("An attempt to delete the file '" + remoteFile + "' failed : " + e.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1);
                }
            }
        }
    }

    public Document get(String filePattern) throws IOException {
        Document doc = null;
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        while (doc == null) {
            if (++numberOfTries > maxTries) {
                throw new IOException("Error occurred while getting '" + filePattern + "' file from the FTP server");
            }
            try {
                this.logger.finest("start getting '" + filePattern + "' file from the FTP server");
                FTPFile[] files = this.listFiles(filePattern);
                if (files != null && files.length > 0) {
                    doc = this.getAsDocument(files[0].getName());
                    continue;
                }
                throw new IOException("Can not find the specified resource");
            }
            catch (IOException e) {
                if (numberOfTries == maxTries) {
                    throw e;
                }
                this.logger.warning("An attempt to get the file '" + filePattern + "' failed : " + e.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1);
                }
            }
        }
        return doc;
    }

    public FTPConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public DataHandler getFileAsAttachment(String filePatternWildCard) throws IOException {
        DataHandler data = null;
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        while (data == null) {
            if (++numberOfTries > maxTries) {
                throw new IOException("Error occurred while getting '" + filePatternWildCard + "' file from the FTP server");
            }
            try {
                this.logger.finest("start getting '" + filePatternWildCard + "' file from the FTP server");
                FTPFile[] files = this.listFiles(filePatternWildCard);
                if (files != null && files.length > 0) {
                    data = this.getAsDataHandler(files[0]);
                    continue;
                }
                throw new IOException("Can not find the specified resource");
            }
            catch (IOException e) {
                if (numberOfTries == maxTries) {
                    throw e;
                }
                this.logger.warning("An attempt to get the file '" + filePatternWildCard + "' failed : " + e.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException e1) {
                    throw new IOException(e1);
                }
            }
        }
        return data;
    }

    public void connectAndLog() throws IOException {
        this.logger.finest("create FTP connection to " + this.connectionInfo.getServer());
        this.setControlEncoding(this.connectionInfo.getEncoding());
        this.connect(this.connectionInfo.getServer(), this.connectionInfo.getPort());
        int reply = this.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.disconnect();
            throw new IOException("connection to FTP server failed.");
        }
        boolean logged = this.login(this.connectionInfo.getUser(), this.connectionInfo.getPassword());
        if (!logged) {
            throw new IOException("authentication failed.");
        }
        this.logger.finest(this.connectionInfo.toString());
    }

    public List<String> listFolderContent() throws IOException {
        ArrayList<String> fileList = new ArrayList<String>();
        boolean listAllFiles = false;
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        while (!listAllFiles) {
            try {
                this.logger.finest("start listing a directory from the FTP server");
                for (FTPFile file : this.listFiles()) {
                    if (!file.isFile()) continue;
                    fileList.add(file.getName());
                }
                listAllFiles = true;
            }
            catch (IOException e) {
                if (++numberOfTries == maxTries) {
                    throw e;
                }
                this.logger.warning("An attempt to list a directory failed : " + e.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1);
                }
            }
        }
        return fileList;
    }

    public void mDel(List<String> remoteFiles) throws IOException {
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        boolean deletedAllFile = false;
        while (!deletedAllFile) {
            try {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start deleting '" + remoteFiles.toString() + "' file from the FTP server");
                }
                for (String pathname : remoteFiles) {
                    this.deleteFile(pathname);
                }
                deletedAllFile = true;
            }
            catch (IOException e) {
                if (numberOfTries == maxTries) {
                    throw e;
                }
                this.logger.warning("An attempt to delete the file '" + remoteFiles + "' failed : " + e.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1);
                }
            }
        }
    }

    public Map<String, DataHandler> mGet(List<String> filePatternWildCardList) throws IOException {
        boolean getAllFiles = false;
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        HashMap<String, DataHandler> datahandlers = new HashMap<String, DataHandler>();
        LinkedList<FileNamePatternUtil.RegexFileNameFilter> fileNameFilters = new LinkedList<FileNamePatternUtil.RegexFileNameFilter>();
        for (String string : filePatternWildCardList) {
            fileNameFilters.add(FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(string));
        }
        FileNamePatternUtil.RegexFileNameFilter filter = FileNamePatternUtil.getInstance().buildFileNameFilterFromFilters(fileNameFilters);
        while (!getAllFiles) {
            try {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start getting files from the FTP server");
                }
                for (FTPFile file : this.listFiles()) {
                    if (!file.isFile() || !filter.accept(null, file.getName())) continue;
                    datahandlers.put(file.getName(), this.getAsDataHandler(file));
                }
                getAllFiles = true;
            }
            catch (IOException e) {
                if (++numberOfTries >= maxTries) {
                    throw e;
                }
                this.logger.warning("An attempt to get a file failed : " + e.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1);
                }
            }
        }
        return datahandlers;
    }

    public void mPut(Map<String, DataHandler> attachments) throws IOException {
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
            boolean transmit = false;
            boolean isFileExist = false;
            while (!transmit) {
                if (numberOfTries == maxTries) {
                    throw new IOException("Error occurred while storing '" + entry.getKey() + "' file on the FTP server");
                }
                try {
                    this.logger.finest("start sending '" + entry.getKey() + "' file on the FTP server");
                    isFileExist = this.fileExistOnRemoteDirectory(entry.getKey());
                    if (isFileExist && !this.connectionInfo.isOverwrite()) {
                        numberOfTries = maxTries;
                        throw new IOException("File [" + entry.getKey() + "] already exists");
                    }
                    InputStream stream = entry.getValue().getInputStream();
                    transmit = this.storeFile(entry.getKey(), stream);
                    stream.close();
                    if (transmit) {
                        this.logger.finest("'" + entry.getKey() + "' sent on the FTP server");
                        continue;
                    }
                    ++numberOfTries;
                }
                catch (IOException e) {
                    if (++numberOfTries >= maxTries) {
                        throw e;
                    }
                    this.logger.warning("An attempt to put the file '" + entry.getKey() + "' failed : " + e.getMessage());
                    try {
                        Thread.sleep(this.connectionInfo.getDelay());
                    }
                    catch (InterruptedException ex1) {
                        throw new IOException(ex1);
                    }
                }
            }
        }
    }

    public void putString(String fileName, String content) throws IOException {
        boolean transmit = false;
        boolean fileExist = false;
        int numberOfTries = 0;
        int maxTries = this.connectionInfo.getAttempt();
        while (!transmit) {
            if (++numberOfTries > maxTries) {
                throw new IOException("Error occurred while storing '" + fileName + "' file on the FTP server");
            }
            try {
                this.logger.finest("start sending '" + fileName + "' file on the FTP server");
                fileExist = this.fileExistOnRemoteDirectory(fileName);
                if (!fileExist || this.connectionInfo.isOverwrite()) {
                    OutputStream ops = this.storeFileStream(fileName);
                    ops.write(content.getBytes());
                    ops.flush();
                    ops.close();
                    transmit = this.completePendingCommand();
                    continue;
                }
                numberOfTries = maxTries;
                throw new IOException("File [" + fileName + "] already exists");
            }
            catch (IOException e) {
                if (numberOfTries >= maxTries) {
                    throw e;
                }
                this.logger.warning("An attempt to put the file '" + fileName + "' failed : " + e.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1);
                }
            }
        }
        this.logger.finest("'" + fileName + "' sent on the FTP server");
    }

    private boolean fileExistOnRemoteDirectory(String srcFileName) throws IOException {
        String[] remoteFileNames;
        boolean fileExist = false;
        for (String remoteFileName : remoteFileNames = this.listNames()) {
            if (!remoteFileName.equals(srcFileName)) continue;
            fileExist = true;
            break;
        }
        return fileExist;
    }

    private DataHandler getAsDataHandler(FTPFile remoteFile) throws IOException {
        this.logger.info("start receiving file " + remoteFile.getName() + " from FTP server");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)remoteFile.getSize());
        try {
            this.retrieveFile(remoteFile.getName(), outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            outputStream.close();
        }
        this.logger.finest(remoteFile.getName() + " file received from FTP server");
        ByteArrayDataSource datasource = new ByteArrayDataSource(outputStream.toByteArray(), FileTypeMap.getDefaultFileTypeMap().getContentType(remoteFile.getName()));
        datasource.setName(remoteFile.getName());
        DataHandler result = new DataHandler((DataSource)datasource);
        this.logger.finest(remoteFile.getName() + " set as DataHandler");
        return result;
    }

    private Document getAsDocument(String remoteFileName) throws IOException {
        Document doc;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("start receiving file " + remoteFileName + " from FTP server");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.retrieveFile(remoteFileName, bos);
        bos.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
        try {
            doc = XMLUtil.loadDocument((InputStream)is);
        }
        catch (SAXException e) {
            throw new IOException("processed file '" + remoteFileName + "' is not a valid xml file : " + e.getMessage());
        }
        finally {
            bos.close();
            is.close();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(remoteFileName + " file received from FTP server and set as document");
        }
        return doc;
    }
}

