/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.connection;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.nio.charset.Charset;
import org.ow2.petals.bc.ftp.MissingElementException;

public class FTPConnectionInfo {
    private int attempt;
    private String connectionMode;
    private long delay;
    private boolean deleteProcessedFile;
    private String encoding;
    private String folder;
    private int maxConnection;
    private long maxIdleTime;
    private boolean overwrite;
    private String password;
    private int port;
    private String server;
    private String transferType;
    private String user;

    public FTPConnectionInfo(String server, int port, String user, String password, String directory, String connectionMode, String transferType, int attempt, long delay, boolean deleteProcessedFile, String encoding, boolean overwrite) {
        this.connectionMode = connectionMode;
        this.folder = directory;
        this.password = password;
        this.port = port;
        this.server = server;
        this.transferType = transferType;
        this.user = user;
        this.attempt = attempt;
        this.delay = delay;
        this.deleteProcessedFile = deleteProcessedFile;
        this.encoding = encoding;
        this.overwrite = overwrite;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public String getConnectionMode() {
        return this.connectionMode;
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean getDeleteProcessedFile() {
        return this.deleteProcessedFile;
    }

    public String getDirectory() {
        return this.folder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isActiveMode() {
        return !this.isPassiveMode();
    }

    public boolean isAsciiTransferType() {
        return "ascii".equalsIgnoreCase(this.transferType);
    }

    public boolean isBinaryTransferType() {
        return "binary".equalsIgnoreCase(this.transferType);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isPassiveMode() {
        return "passive".equalsIgnoreCase(this.connectionMode);
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setDeleteProcessedFile(boolean deleteProcessedFile) {
        this.deleteProcessedFile = deleteProcessedFile;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String toString() {
        return "FTP Connection Info :server=" + this.server + "; port=" + this.port + "; user=" + this.user + "; password=" + this.password + "; directory=" + this.folder + "; transfer-type=" + this.transferType + "; connection-mode :" + this.connectionMode + "; encoding :" + this.encoding + "; overwrite :" + this.overwrite + "; delete processed  file :" + this.deleteProcessedFile;
    }

    public void validate() throws MissingElementException {
        if (StringHelper.isNullOrEmpty((String)this.server)) {
            throw new MissingElementException("server");
        }
        if (StringHelper.isNullOrEmpty((String)this.user)) {
            throw new MissingElementException("user");
        }
        if (StringHelper.isNullOrEmpty((String)this.password)) {
            throw new MissingElementException("password");
        }
        if (this.port == 0) {
            throw new MissingElementException("port");
        }
        if (this.connectionMode != null && !this.connectionMode.equalsIgnoreCase("active") && !this.connectionMode.equalsIgnoreCase("passive")) {
            throw new MissingElementException("connection-mode");
        }
        if (this.transferType != null && !this.transferType.equalsIgnoreCase("ascii") && !this.transferType.equalsIgnoreCase("binary")) {
            throw new MissingElementException("transfer-type");
        }
        if (this.encoding == null || !Charset.isSupported(this.encoding)) {
            this.encoding = Charset.defaultCharset().toString();
        }
    }
}

