/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl20;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractBindingImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.impl.wsdl20.BindingOperationImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl20.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl20.DocumentationImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLReaderImpl;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.BindingOperationType;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.BindingType;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.DescriptionType;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.ObjectFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BindingImpl
extends AbstractBindingImpl<BindingType, InterfaceType, BindingOperation>
implements Binding {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(BindingImpl.class.getName());
    private ObjectFactory factory = new ObjectFactory();

    public BindingImpl(BindingType bindingType, DescriptionImpl descriptionImpl) {
        super(bindingType, descriptionImpl);
        this.desc = descriptionImpl;
        this.documentation = new DocumentationImpl(((BindingType)this.model).getDocumentation(), (AbstractWSDLElementImpl)this);
        QName qName = ((BindingType)this.model).getInterface();
        this.itf = (InterfaceType)this.desc.getInterface(qName);
        for (Object object : ((BindingType)this.model).getOperationOrFaultOrAny()) {
            Object object2;
            if (!(object instanceof JAXBElement) || !((object2 = ((JAXBElement)object).getValue()) instanceof BindingOperationType)) continue;
            BindingOperationImpl bindingOperationImpl = new BindingOperationImpl((BindingOperationType)object2, this);
            this.bindingOperations.add(bindingOperationImpl);
        }
    }

    @Override
    public void addBindingOperation(BindingOperation bindingOperation) {
        JAXBElement<BindingOperationType> jAXBElement = this.factory.createBindingTypeOperation((BindingOperationType)((AbstractWSDLElementImpl)((Object)bindingOperation)).getModel());
        super.addBindingOperation(bindingOperation);
        ((BindingType)this.model).getOperationOrFaultOrAny().add(jAXBElement);
    }

    @Override
    public QName getQName() {
        return new QName(this.desc.getTargetNamespace(), ((BindingType)this.model).getName());
    }

    @Override
    public BindingOperation removeBindingOperation(String string) {
        throw new NotImplementedException();
    }

    @Override
    public void setInterface(InterfaceType interfaceType) {
        ((BindingType)this.model).setInterface(interfaceType.getQName());
        this.itf = interfaceType;
    }

    @Override
    public void setQName(QName qName) {
        ((BindingType)this.model).setName(qName.getLocalPart());
    }

    @Override
    public String getTransportProtocol() {
        String string = null;
        for (Map.Entry<QName, String> entry : ((BindingType)this.model).getOtherAttributes().entrySet()) {
            if (entry.getKey().getLocalPart().equals("protocol") && entry.getKey().getNamespaceURI().equals(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString())) {
                string = entry.getValue();
                break;
            }
            if (!entry.getKey().getLocalPart().equals("method") && !entry.getKey().getLocalPart().equals("methodDefault") || !entry.getKey().getNamespaceURI().equals(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString())) continue;
            string = entry.getValue();
            break;
        }
        return string;
    }

    @Override
    public void setTransportProtocol(String string) {
        if (string.contains("soap")) {
            ((BindingType)this.model).setType(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString());
            ((BindingType)this.model).getOtherAttributes().put(new QName(((BindingType)this.model).getType(), "protocol"), string);
        } else if (string.contains("http")) {
            ((BindingType)this.model).setType(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString());
            ((BindingType)this.model).getOtherAttributes().put(new QName(((BindingType)this.model).getType(), "methodDefault"), string);
        } else {
            LOG.severe("unrecognized transport protocol");
        }
    }

    @Override
    public AbsItfBinding.StyleConstant getStyle() {
        return AbsItfBinding.StyleConstant.DOCUMENT;
    }

    @Override
    public AbsItfBinding.BindingConstants getTypeOfBinding() {
        AbsItfBinding.BindingConstants bindingConstants = null;
        try {
            if (((BindingType)this.model).getType() != null) {
                bindingConstants = AbsItfBinding.BindingConstants.valueOf(new URI(((BindingType)this.model).getType()));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.warning("The binding type is unknown");
        }
        return bindingConstants;
    }

    @Override
    public String getVersion() {
        String string = null;
        string = ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "version"));
        if (string == null) {
            string = ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString(), "version"));
        }
        return string;
    }

    @Override
    public String getHttpContentEncodingDefault() {
        return ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "contentEncodingDefault"));
    }

    @Override
    public String getHttpDefaultMethod() {
        return ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "methodDefault"));
    }

    @Override
    public String getHttpQueryParameterSeparatorDefault() {
        return ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "queryParameterSeparatorDefault"));
    }

    @Override
    public boolean isHttpCookies() {
        return Boolean.valueOf(((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "cookies")));
    }

    @Override
    public List<Element> getOtherElements() throws XmlException {
        List<Element> list = super.getOtherElements();
        for (Object object : ((BindingType)this.model).getOperationOrFaultOrAny()) {
            if (!(object instanceof Element)) continue;
            list.add((Element)object);
        }
        return list;
    }

    @Override
    public BindingOperation createBindingOperation() {
        return new BindingOperationImpl(new BindingOperationType(), this);
    }

    public static BindingType replaceDOMElementByBindingType(WSDLElement wSDLElement, Element element, WSDLReaderImpl wSDLReaderImpl) throws WSDLException {
        BindingType bindingType = null;
        try {
            if (element != null && element.getLocalName().equals("binding") && element.getNamespaceURI().equals("http://www.w3.org/ns/wsdl")) {
                Unmarshaller unmarshaller = WSDLJAXBContext.getInstance().getJaxbContext().createUnmarshaller();
                JAXBElement jAXBElement = unmarshaller.unmarshal((Node)element, BindingType.class);
                ((DescriptionType)((AbstractWSDLElementImpl)wSDLElement).getModel()).getImportOrIncludeOrTypes().remove(element);
                ((DescriptionType)((AbstractWSDLElementImpl)wSDLElement).getModel()).getImportOrIncludeOrTypes().add(jAXBElement.getValue());
                bindingType = (BindingType)jAXBElement.getValue();
            }
        }
        catch (JAXBException jAXBException) {
            throw new WSDLException(jAXBException);
        }
        return bindingType;
    }
}

