/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.ow2.petals.bc.mail.listeners.SessionDescriptor;
import org.ow2.petals.component.framework.util.StringHelper;

public class MailSessionManager {
    protected Logger log;

    public MailSessionManager(Logger log) {
        this.log = log;
    }

    protected void closeFolderAndStore(Folder folder, Store store, boolean expunge) {
        block7: {
            block6: {
                try {
                    if (folder != null && folder.isOpen()) {
                        folder.close(expunge);
                    }
                }
                catch (Exception ex) {
                    if (folder == null) break block6;
                    this.log.log(Level.WARNING, "Error closing mail Folder :" + folder.toString(), ex);
                }
            }
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
            }
            catch (Exception ex) {
                if (store == null) break block7;
                this.log.log(Level.WARNING, "Error closing mail Store : " + store.toString(), ex);
            }
        }
    }

    public Session createSessionPropertiesFromDescriptor(SessionDescriptor sessionDescriptor) {
        Properties props = new Properties();
        if ("smtp".equals(sessionDescriptor.getScheme())) {
            props.put("mail.transport.protocol", sessionDescriptor.getScheme());
        } else {
            props.put("mail.store.protocol", sessionDescriptor.getScheme());
        }
        props.put("mail.host", sessionDescriptor.getHostname());
        if (sessionDescriptor.getUsername() != null) {
            props.put("mail.user", sessionDescriptor.getUsername());
        }
        if (sessionDescriptor.getFromAddress() != null) {
            props.put("mail.from", sessionDescriptor.getFromAddress());
        }
        if (sessionDescriptor.getHeloHost() != null) {
            props.put("mail.smtp.localhost", sessionDescriptor.getHeloHost());
        }
        return Session.getInstance(props);
    }

    public Folder getFolderAndOpen(Store store, SessionDescriptor sessionDescriptor) throws MessagingException {
        String msg = "";
        Folder folder = null;
        folder = store.getDefaultFolder();
        if (folder == null) {
            msg = "No default folder for this store : " + store.toString();
            this.log.warning(msg);
            throw new MessagingException(msg);
        }
        if ((folder = folder.getFolder(sessionDescriptor.getFolder())) == null) {
            msg = "Invalid folder : " + sessionDescriptor.getFolder();
            this.log.warning(msg);
            throw new MessagingException(msg);
        }
        folder.open(2);
        return folder;
    }

    public List<Message> getNewMails(Folder folder) throws MessagingException {
        Message[] lstMessage;
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Message message : lstMessage = folder.getMessages()) {
            if (message.isSet(Flags.Flag.DELETED)) continue;
            messages.add(message);
        }
        return messages;
    }

    public Store getStoreAndConnect(Session session, SessionDescriptor sessionDescriptor) throws MessagingException {
        Store store = null;
        store = session.getStore(sessionDescriptor.getScheme());
        store.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), sessionDescriptor.getUsername(), sessionDescriptor.getPassword());
        return store;
    }

    public void sendMail(MimeMessage mimeMessage, SessionDescriptor sessionDescriptor, Session session) throws MessagingException {
        Transport transport = session.getTransport("smtp");
        if (!StringHelper.isNullOrEmpty((String)sessionDescriptor.getUsername()) && !StringHelper.isNullOrEmpty((String)sessionDescriptor.getPassword())) {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), sessionDescriptor.getUsername(), sessionDescriptor.getPassword());
        } else if (!StringHelper.isNullOrEmpty((String)sessionDescriptor.getUsername())) {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), sessionDescriptor.getUsername(), null);
        } else {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), null, null);
        }
        mimeMessage.saveChanges();
        transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());
        transport.close();
    }
}

