/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.internet.InternetAddress;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.listeners.SessionDescriptor;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SessionDescriptorBuilder {
    protected Logger log;
    private final AbstractBindingComponent component;

    public SessionDescriptorBuilder(Logger log, AbstractBindingComponent component) {
        this.log = log;
        this.component = component;
    }

    public SessionDescriptor build(ConfigurationExtensions extensions) throws PEtALSCDKException, MissingElementException {
        SessionDescriptor sessionDescriptor = new SessionDescriptor();
        sessionDescriptor.setUsername(extensions.get((Object)"user", null));
        sessionDescriptor.setPassword(extensions.get((Object)"password", null));
        String scheme = extensions.get((Object)"scheme");
        sessionDescriptor.setScheme(scheme);
        sessionDescriptor.setHostname(extensions.get((Object)"host"));
        if ("pop3".equals(scheme)) {
            sessionDescriptor.setPort(extensions.get((Object)"port", "110"));
        } else if ("imap".equals(scheme)) {
            sessionDescriptor.setPort(extensions.get((Object)"port", "143"));
        } else {
            sessionDescriptor.setPort(extensions.get((Object)"port", "25"));
            String host = null;
            host = extensions.get((Object)"helohost");
            if (host != null) {
                sessionDescriptor.setHeloHost(host);
            }
        }
        if ("smtp".equalsIgnoreCase(scheme)) {
            String fromAddress = extensions.get((Object)"from");
            if (StringHelper.isNullOrEmpty((String)fromAddress)) {
                throw new MissingElementException("from");
            }
            sessionDescriptor.setFromAddress(fromAddress);
            String replyAddress = extensions.get((Object)"reply");
            sessionDescriptor.setReplyAddress(replyAddress);
            String toAddress = extensions.get((Object)"to");
            if (StringHelper.isNullOrEmpty((String)toAddress)) {
                throw new MissingElementException("to");
            }
            sessionDescriptor.setToAddress(toAddress);
            String subject = extensions.get((Object)"subject");
            if (StringHelper.isNullOrEmpty((String)subject)) {
                subject = "petals-bc-mail";
            }
            sessionDescriptor.setSubject(subject);
            String sendMode = extensions.get((Object)"send-mode");
            if (StringHelper.isNullOrEmpty((String)sendMode)) {
                sessionDescriptor.setSendMode("content-and-attachments");
            } else {
                sessionDescriptor.setSendMode(sendMode);
            }
        } else {
            sessionDescriptor.setPeriod(extensions.get((Object)"period", "60000"));
            sessionDescriptor.setFolder(extensions.get((Object)"folder", "INBOX"));
            String s_expunge = extensions.get((Object)"delete");
            if (StringHelper.isNullOrEmpty((String)s_expunge)) {
                sessionDescriptor.setDelete(true);
            } else {
                sessionDescriptor.setDelete(Boolean.getBoolean(s_expunge));
            }
        }
        this.checkProperties(sessionDescriptor);
        return sessionDescriptor;
    }

    public SessionDescriptor buildFromPayload(Exchange exchange) throws MissingElementException, PEtALSCDKException {
        SessionDescriptor sessionDescriptor = this.buildTechnicalProperties();
        Document doc = null;
        try {
            doc = exchange.getInMessageContentAsDocument(true);
        }
        catch (MessagingException messagingException) {
            this.log.warning(messagingException.getMessage());
        }
        Node rootNode = doc.getFirstChild();
        if (rootNode == null || !rootNode.getLocalName().equalsIgnoreCase("mail")) {
            throw new MissingElementException("mail");
        }
        Node fromNode = XMLUtil.findChild((Node)rootNode, (String)"from", null, (boolean)false);
        try {
            new InternetAddress(fromNode.getTextContent()).validate();
            sessionDescriptor.setFromAddress(fromNode.getTextContent());
        }
        catch (Exception e) {
            throw new MissingElementException("from");
        }
        Node replyNode = XMLUtil.findChild((Node)rootNode, (String)"reply", null, (boolean)false);
        try {
            new InternetAddress(replyNode.getTextContent()).validate();
            sessionDescriptor.setReplyAddress(replyNode.getTextContent());
        }
        catch (Exception e) {
            this.log.warning("Element reply is not define");
            sessionDescriptor.setReplyAddress("");
        }
        Node toNode = XMLUtil.findChild((Node)rootNode, (String)"to", null, (boolean)false);
        try {
            new InternetAddress(toNode.getTextContent()).validate();
            sessionDescriptor.setToAddress(toNode.getTextContent());
        }
        catch (Exception e) {
            throw new MissingElementException("to");
        }
        Node subjectNode = XMLUtil.findChild((Node)rootNode, (String)"subject", null, (boolean)false);
        if (subjectNode == null) {
            throw new MissingElementException("subject");
        }
        sessionDescriptor.setSubject(subjectNode.getTextContent());
        Node bodyNode = XMLUtil.findChild((Node)rootNode, (String)"body", null, (boolean)false);
        String body = null;
        if (bodyNode == null) {
            throw new MissingElementException("body");
        }
        body = bodyNode.getTextContent();
        sessionDescriptor.setBody(body);
        this.checkProperties(sessionDescriptor);
        return sessionDescriptor;
    }

    public SessionDescriptor buildFromProperties(Exchange exchange) throws MissingElementException, PEtALSCDKException {
        SessionDescriptor sessionDescriptor = this.buildTechnicalProperties();
        NormalizedMessage inNormalizedMessage = exchange.getInMessage();
        String fromAddress = (String)inNormalizedMessage.getProperty(Constants.WSStar.Addressing.FROM_QNAME.toString());
        if (StringHelper.isNullOrEmpty((String)fromAddress)) {
            fromAddress = "petals@ow2.org";
        }
        sessionDescriptor.setFromAddress(fromAddress);
        String toAddress = null;
        try {
            Object object;
            if (exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing") != null && (object = exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing")) instanceof Document) {
                toAddress = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType((Document)object).getAddress();
            }
        }
        catch (MessagingException e) {
        }
        catch (WSAddressingException e) {
            // empty catch block
        }
        if (StringHelper.isNullOrEmpty(toAddress)) {
            toAddress = (String)inNormalizedMessage.getProperty(Constants.WSStar.Addressing.TO_QNAME.toString());
        }
        if (StringHelper.isNullOrEmpty(toAddress)) {
            throw new MissingElementException(Constants.WSStar.Addressing.TO_QNAME.toString(), "missing ws addressing properties : ");
        }
        sessionDescriptor.setToAddress(toAddress);
        String replyAddress = (String)inNormalizedMessage.getProperty(Constants.WSStar.Addressing.REPLY_TO_QNAME.toString());
        if (StringHelper.isNullOrEmpty((String)replyAddress)) {
            replyAddress = "petals@ow2.org";
        }
        sessionDescriptor.setReplyAddress(replyAddress);
        String subject = (String)inNormalizedMessage.getProperty(Constants.WSStar.Addressing.ACTION_QNAME.toString());
        if (StringHelper.isNullOrEmpty((String)subject)) {
            subject = "Mail from PEtALS";
        }
        sessionDescriptor.setSubject(subject);
        this.checkProperties(sessionDescriptor);
        return sessionDescriptor;
    }

    private SessionDescriptor buildTechnicalProperties() {
        ConfigurationExtensions ext = this.component.getComponentExtensions();
        SessionDescriptor sessionDescriptor = new SessionDescriptor();
        sessionDescriptor.setHostname(ext.get((Object)"host"));
        sessionDescriptor.setScheme("smtp");
        String port = ext.get((Object)"port");
        if (StringHelper.isNullOrEmpty((String)port)) {
            port = "25";
        }
        sessionDescriptor.setPort(port);
        sessionDescriptor.setUsername(ext.get((Object)"user"));
        sessionDescriptor.setPassword(ext.get((Object)"password"));
        sessionDescriptor.setSendMode("content-and-attachments");
        return sessionDescriptor;
    }

    protected void checkProperties(SessionDescriptor sessionDescriptor) throws PEtALSCDKException {
        if (StringHelper.isNullOrEmpty((String)sessionDescriptor.getHostname())) {
            String msg = "The host name of the requested external service must be specified";
            this.log.warning(msg);
            throw new PEtALSCDKException(msg);
        }
        if (!("imap".equalsIgnoreCase(sessionDescriptor.getScheme()) || "pop3".equalsIgnoreCase(sessionDescriptor.getScheme()) || "smtp".equalsIgnoreCase(sessionDescriptor.getScheme()))) {
            String msg = "The specified scheme isn't supported : " + sessionDescriptor.getScheme();
            this.log.warning(msg);
            throw new PEtALSCDKException(msg);
        }
    }

    public boolean checkWsaProperties(Exchange exchange) {
        String fromAddress = (String)exchange.getInMessage().getProperty(Constants.WSStar.Addressing.FROM_QNAME.toString());
        String toAddress = (String)exchange.getInMessage().getProperty(Constants.WSStar.Addressing.TO_QNAME.toString());
        if (!StringHelper.isNullOrEmpty((String)fromAddress) || !StringHelper.isNullOrEmpty((String)toAddress)) {
            this.log.info("WS addressing properties found");
            return true;
        }
        return false;
    }

    public void setIOFaultOnExchange(Exchange exchange, String ioMessage) throws JBIException {
        StringBuffer faultMessage = new StringBuffer();
        faultMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        faultMessage.append("<tns:ioFault xmlns:tns='");
        faultMessage.append("http://petals.ow2.org/components/mail/version-3");
        faultMessage.append("'><tns:message>");
        faultMessage.append(ioMessage);
        faultMessage.append("</tns:message></tns:ioFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(UtilFactory.getSourceUtil().createSource(faultMessage.toString(), "UTF-8"));
            exchange.setFault(fault);
        }
        catch (PEtALSCDKException e) {
            throw new JBIException(e.getMessage());
        }
    }

    public void setMissingElementFaultOnExchange(Exchange exchange, String missingElement) throws JBIException {
        StringBuffer faultMessage = new StringBuffer();
        faultMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        faultMessage.append("<tns:missingElementFault xmlns:tns='");
        faultMessage.append("http://petals.ow2.org/components/mail/version-3");
        faultMessage.append("'><tns:element>");
        faultMessage.append(missingElement);
        faultMessage.append("</tns:element></tns:missingElementFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(UtilFactory.getSourceUtil().createSource(faultMessage.toString(), "UTF-8"));
        }
        catch (PEtALSCDKException e) {
            throw new JBIException(e.getMessage());
        }
        exchange.setFault(fault);
    }
}

