/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.service;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.listeners.MailSessionManager;
import org.ow2.petals.bc.mail.listeners.MimeMessageManager;
import org.ow2.petals.bc.mail.listeners.SessionDescriptor;
import org.ow2.petals.bc.mail.listeners.SessionDescriptorBuilder;
import org.ow2.petals.component.framework.api.message.Exchange;

public class SendMailGenericService {
    protected MailSessionManager mailSessionManager;
    protected MimeMessageManager mimeMessageManager;
    protected SessionDescriptorBuilder sessionDescriptorBuilder;
    private final Logger logger;

    public SendMailGenericService(MailSessionManager mailSessionManager, MimeMessageManager mimeMessageManager, SessionDescriptorBuilder sessionDescriptorBuilder, Logger logger) {
        this.logger = logger;
        this.mailSessionManager = mailSessionManager;
        this.mimeMessageManager = mimeMessageManager;
        this.sessionDescriptorBuilder = sessionDescriptorBuilder;
    }

    public void sendMailGenericService(Exchange exchange) throws JBIException, MessagingException, IOException {
        if (this.sessionDescriptorBuilder.checkWsaProperties(exchange)) {
            this.sendMailServiceByProperties(exchange);
        } else {
            this.sendMailServiceByPayload(exchange);
        }
    }

    protected void sendMailServiceByPayload(Exchange exchange) throws JBIException, IOException, MessagingException {
        this.logger.info("JBI Exchange received - sendMail service requested");
        SessionDescriptor sessionDescriptor = this.sessionDescriptorBuilder.buildFromPayload(exchange);
        Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(sessionDescriptor);
        MimeMessage mimeMessage = this.mimeMessageManager.mapNormalizedMessageToMimeMessage(session, sessionDescriptor, exchange.getInMessage());
        Multipart multipart = (Multipart)mimeMessage.getContent();
        BodyPart messageBodyPart = multipart.getBodyPart(0);
        messageBodyPart.setContent(sessionDescriptor.getBody(), "text/plain");
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("send email...");
        }
        this.mailSessionManager.sendMail(mimeMessage, sessionDescriptor, session);
        this.logger.info("email sent to " + sessionDescriptor.getToAddress());
    }

    protected void sendMailServiceByProperties(Exchange exchange) throws MessagingException, JBIException, MissingElementException {
        SessionDescriptor sessionDescriptor = null;
        sessionDescriptor = this.sessionDescriptorBuilder.buildFromProperties(exchange);
        Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(sessionDescriptor);
        MimeMessage mimeMessage = this.mimeMessageManager.mapNormalizedMessageToMimeMessage(session, sessionDescriptor, exchange.getInMessage());
        this.mailSessionManager.sendMail(mimeMessage, sessionDescriptor, session);
        this.logger.log(Level.INFO, "email sent to " + sessionDescriptor.getToAddress());
    }
}

