/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.listener;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import java.util.List;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractListener;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;

public abstract class AbstractJBIListener
extends AbstractListener {
    public boolean onAsyncJBIMessage(Exchange asyncExchange, AsyncContext asyncContext) {
        return false;
    }

    public boolean onAsyncNotificationMessage(Exchange asyncExchange, AsyncContext asyncContext) {
        return false;
    }

    public boolean onExpiredAsyncJBIMessage(Exchange originalExchange, AsyncContext asyncContext) {
        return false;
    }

    public boolean onExpiredAsyncNotificationMessage(Exchange originalExchange, AsyncContext asyncContext) {
        return false;
    }

    public abstract boolean onJBIMessage(Exchange var1);

    public boolean onNotificationMessage(Exchange exchange) {
        boolean response = true;
        NormalizedMessage normalizedMessage = null;
        Document document = null;
        EndpointReferenceType endpointReferenceType = null;
        String address = null;
        try {
            if (this.getLogger().isLoggable(Level.FINE)) {
                for (QName intf : exchange.getEndpoint().getInterfaces()) {
                    this.getLogger().fine("notification endpoint interface: " + intf);
                }
                this.getLogger().fine("notification endpoint service: " + exchange.getEndpoint().getServiceName());
                this.getLogger().fine("notification endpoint name: " + exchange.getEndpoint().getEndpointName());
                this.getLogger().fine("notification operation name: " + exchange.getOperationName());
            }
            if (exchange.isActiveStatus()) {
                if (exchange.getFault() != null) {
                    if (UtilFactory.getExchangeUtil().isPetalsException(exchange.getFault())) {
                        this.getLogger().warning("notification technical fault message content: " + UtilFactory.getSourceUtil().createString(exchange.getFault().getContent()));
                    } else {
                        this.getLogger().warning("notification business fault message content: " + UtilFactory.getSourceUtil().createString(exchange.getFault().getContent()));
                    }
                } else if (this.component.getNotificationBrokerController() == null) {
                    this.getLogger().warning("Unable to analyze the notification : the notification broker controller isn't initialized");
                } else {
                    normalizedMessage = exchange.getInMessage();
                    if (WsnbConstants.SUBSCRIBE_QNAME.equals(exchange.getOperation())) {
                        document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                        Subscribe subscribe = WSNotificationReader.getInstance().readSubscribe(document);
                        address = subscribe.getConsumerReference().getAddress();
                        if (address == null || this.component.getNotificationBrokerController().isInternalNotification(address)) {
                            SubscribeResponse subscribeResponse = this.component.getNotificationBrokerController().getNotificationProducer().subscribe(subscribe);
                            document = WSNotificationWriter.getInstance().writeSubscribeResponse(subscribeResponse);
                            normalizedMessage = exchange.getOutMessage();
                            normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                            exchange.setOutMessage(normalizedMessage);
                        } else {
                            ((ExchangeImpl)exchange).setCheckRole(false);
                            endpointReferenceType = WSAddressingFactory.getInstance().newEndpointReferenceType();
                            if (normalizedMessage.getProperty("com.ebmwebsourcing.wsstar.addressing") == null) {
                                endpointReferenceType.setAddress(address);
                                document = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(endpointReferenceType);
                                normalizedMessage.setProperty("com.ebmwebsourcing.wsstar.addressing", (Object)document);
                            }
                            subscribe = this.component.getNotificationBrokerController().getTransformer().transformRequestOnProducer(subscribe);
                            document = WSNotificationWriter.getInstance().writeSubscribe(subscribe);
                            normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                            exchange.setInMessage(normalizedMessage);
                            response = this.onJBIMessage(exchange);
                            if (exchange.isActiveStatus() && exchange.getOutMessage() != null) {
                                normalizedMessage = exchange.getOutMessage();
                                document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                                SubscribeResponse subscribeResponse = WSNotificationReader.getInstance().readSubscribeResponse(document);
                                subscribeResponse = this.component.getNotificationBrokerController().getTransformer().transformResponseOnProducer(subscribeResponse);
                                document = WSNotificationWriter.getInstance().writeSubscribeResponse(subscribeResponse);
                                normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                                exchange.setOutMessage(normalizedMessage);
                            }
                            ((ExchangeImpl)exchange).setCheckRole(true);
                        }
                    } else if (WsnbConstants.NOTIFY_QNAME.equals(exchange.getOperation())) {
                        document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                        Notify notify = WSNotificationReader.getInstance().readNotify(document);
                        List notificationMessageList = notify.getNotificationMessage();
                        if (notificationMessageList == null || notificationMessageList.size() != 1) {
                            exchange.setError(new Exception("The CDK need one and only one notification message"));
                        } else if (((NotificationMessageHolderType)notificationMessageList.get(0)).getSubscriptionReference() != null) {
                            address = ((NotificationMessageHolderType)notificationMessageList.get(0)).getSubscriptionReference().getAddress();
                        }
                        if (address == null || this.component.getNotificationBrokerController().isInternalNotification(address)) {
                            this.component.getNotificationBrokerController().getNotificationConsumer().notify(notify);
                        } else {
                            ((ExchangeImpl)exchange).setCheckRole(false);
                            endpointReferenceType = WSAddressingFactory.getInstance().newEndpointReferenceType();
                            if (normalizedMessage.getProperty("com.ebmwebsourcing.wsstar.addressing") == null) {
                                endpointReferenceType.setAddress(address);
                                document = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(endpointReferenceType);
                                normalizedMessage.setProperty("com.ebmwebsourcing.wsstar.addressing", (Object)document);
                            }
                            notify = this.component.getNotificationBrokerController().getTransformer().transformRequestOnProducer(notify);
                            document = WSNotificationWriter.getInstance().writeNotify(notify);
                            normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                            exchange.setInMessage(normalizedMessage);
                            response = this.onJBIMessage(exchange);
                            ((ExchangeImpl)exchange).setCheckRole(true);
                        }
                    } else if (WsnbConstants.UNSUBSCRIBE_QNAME.equals(exchange.getOperation())) {
                        document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                        Unsubscribe unsubscribe = WSNotificationReader.getInstance().readUnsubscribe(document);
                        EndpointReferenceType endpointReference = WsnSpecificTypeHelper.getEndpointReference((Unsubscribe)unsubscribe);
                        if (endpointReference != null) {
                            address = endpointReference.getAddress();
                        }
                        if (address == null || this.component.getNotificationBrokerController().isInternalNotification(address)) {
                            UnsubscribeResponse unsubscribeResponse = this.component.getNotificationBrokerController().getNotificationProducer().unsubscribe(unsubscribe);
                            document = WSNotificationWriter.getInstance().writeUnsubscribeResponse(unsubscribeResponse);
                            normalizedMessage = exchange.getOutMessage();
                            normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                            exchange.setOutMessage(normalizedMessage);
                        } else {
                            ((ExchangeImpl)exchange).setCheckRole(false);
                            endpointReferenceType = WSAddressingFactory.getInstance().newEndpointReferenceType();
                            if (normalizedMessage.getProperty("com.ebmwebsourcing.wsstar.addressing") == null) {
                                endpointReferenceType.setAddress(address);
                                document = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(endpointReferenceType);
                                normalizedMessage.setProperty("com.ebmwebsourcing.wsstar.addressing", (Object)document);
                            }
                            unsubscribe = this.component.getNotificationBrokerController().getTransformer().transformRequestOnProducer(unsubscribe);
                            document = WSNotificationWriter.getInstance().writeUnsubscribe(unsubscribe);
                            normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                            exchange.setInMessage(normalizedMessage);
                            response = this.onJBIMessage(exchange);
                            ((ExchangeImpl)exchange).setCheckRole(true);
                        }
                    } else if (!WsnbConstants.GET_CURRENT_MESSAGE_QNAME.equals(exchange.getOperation()) && !WsnbConstants.RENEW_QNAME.equals(exchange.getOperation())) {
                        exchange.setError(new Exception("unable to identify an operation of the WS-Notification specifications"));
                    }
                }
            }
        }
        catch (PEtALSCDKException e) {
            exchange.setError(new Exception(e));
        }
        catch (WSNotificationException e) {
            exchange.setError(new Exception(e));
        }
        catch (WSAddressingException e) {
            exchange.setError(new Exception(e));
        }
        catch (MessagingException e) {
            exchange.setError(new Exception(e));
        }
        catch (WSDLException e) {
            exchange.setError(new Exception(e));
        }
        catch (WSNotificationExtensionException e) {
            exchange.setError(new Exception(e));
        }
        catch (XPathExpressionException e) {
            exchange.setError(new Exception(e));
        }
        catch (TransformerFactoryConfigurationError e) {
            exchange.setError(new Exception(e));
        }
        catch (TransformerException e) {
            exchange.setError(new Exception(e));
        }
        catch (ParserConfigurationException e) {
            exchange.setError(new Exception(e));
        }
        catch (WSNotificationFault f) {
            try {
                exchange.setFault((Throwable)f);
            }
            catch (MessagingException e) {
                exchange.setError(new Exception(e));
            }
        }
        return response;
    }
}

