/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.LifeCyle;
import org.ow2.petals.component.framework.api.notification.Sender;
import org.ow2.petals.component.framework.notification.NotificationContext;
import org.ow2.petals.component.framework.util.CustomizableThreadFactory;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;

public class NotificationStorageService
implements LifeCyle {
    static final String TRASH = "trash";
    static final String PERSIST = "persist";
    static final String PUB_REG_RESPONSE = "PubRegResponse";
    static final String POISON = "poison";
    protected static final long RESEND_DELAY = 120L;
    private LifeCyle.STATE state = LifeCyle.STATE.UNKNOWN;
    private final String rootFolder;
    private File folder;
    private File persistFolder;
    private File trashFolder;
    private File pubRegResponseFolder;
    private File pubRegResponseFile;
    private final Logger logger;
    private final AtomicLong fileCounter;
    private final Sender sender;
    private NotificationContext notificationContext;
    private ScheduledExecutorService executor;

    public NotificationStorageService(String folder, Sender sender, NotificationContext notificationContext, Logger logger) {
        this.rootFolder = folder;
        this.logger = logger;
        this.sender = sender;
        this.notificationContext = notificationContext;
        this.fileCounter = new AtomicLong();
    }

    void store(Notify notify) throws PEtALSCDKException {
        block3: {
            this.logger.info("Storing notification");
            try {
                Document document = WSNotificationWriter.getInstance().writeNotify(notify);
                String id = this.getFileName();
                File persistFile = new File(this.persistFolder, id);
                if (persistFile.exists()) {
                    persistFile.createNewFile();
                }
                XMLUtil.writeDocument(document, new FileOutputStream(persistFile));
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block3;
                this.logger.log(Level.WARNING, "Failed to store notification.", e);
            }
        }
        this.start();
    }

    public void store(RegisterPublisherResponse registerPublisherResponse) throws Exception {
        Document regPubRespAsDom = WSNotificationWriter.getInstance().writeRegisterPublisherResponse(registerPublisherResponse);
        XMLUtil.writeDocument(regPubRespAsDom, new FileOutputStream(this.pubRegResponseFile));
    }

    public void destroyPubRegResponseFile() throws Exception {
        if (this.pubRegResponseFile.exists()) {
            this.pubRegResponseFile.delete();
        }
    }

    public RegisterPublisherResponse restorePublisherRegistration() throws WSNotificationException {
        File[] persistedRegPubRespFiles;
        RegisterPublisherResponse result = null;
        if (this.pubRegResponseFolder.exists() && (persistedRegPubRespFiles = this.pubRegResponseFolder.getAbsoluteFile().listFiles()) != null && persistedRegPubRespFiles.length == 1) {
            try {
                result = WSNotificationReader.getInstance().readRegisterPublisherResponse(XMLUtil.loadDocument(new FileInputStream(persistedRegPubRespFiles[0])));
            }
            catch (Exception e) {
                throw new WSNotificationException((Throwable)e);
            }
        }
        return result;
    }

    private String getFileName() {
        return this.fileCounter.incrementAndGet() + "-" + System.currentTimeMillis();
    }

    public void init() {
        if (this.folder == null) {
            this.logger.fine("Creating notification folder");
            this.folder = new File(this.rootFolder, "notifications");
            this.folder.mkdirs();
        }
        if (this.persistFolder == null) {
            this.logger.fine("Creating notification persistance folder");
            this.persistFolder = new File(this.folder, PERSIST);
            this.persistFolder.mkdirs();
        }
        if (this.trashFolder == null) {
            this.logger.fine("Creating notification persistance backup folder");
            this.trashFolder = new File(this.folder, TRASH);
            this.trashFolder.mkdirs();
        }
        if (this.pubRegResponseFolder == null) {
            this.logger.fine("Creating register publisher response persistance backup folder");
            this.pubRegResponseFolder = new File(this.folder, PUB_REG_RESPONSE);
            this.pubRegResponseFolder.mkdirs();
        }
        this.pubRegResponseFile = new File(this.pubRegResponseFolder, "PubRegResponse.xml");
        this.state = LifeCyle.STATE.INIT;
    }

    protected void moveToTrash(File f) throws IOException {
        FileUtils.moveFile(f, new File(this.trashFolder, f.getName()));
    }

    public synchronized void start() {
        if (!LifeCyle.STATE.STARTED.equals((Object)this.state)) {
            this.runPersistedNotifProcessor();
            this.state = LifeCyle.STATE.STARTED;
        }
    }

    private void runPersistedNotifProcessor() {
        String componentName = this.sender.getComponentContext().getComponentName();
        this.executor = new ScheduledThreadPoolExecutor(1, new CustomizableThreadFactory(componentName + " - Persisted notif sender Thread#"));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                File[] persistedNotifs = NotificationStorageService.this.persistFolder.listFiles();
                if (persistedNotifs != null && persistedNotifs.length > 0) {
                    for (File file : persistedNotifs) {
                        try {
                            String fileName = file.getName();
                            NotificationStorageService.this.logger.fine("Processing the file with ID = " + fileName);
                            if (NotificationStorageService.this.notificationContext.isRegistered()) {
                                if (file.exists()) {
                                    Document doc = XMLUtil.loadDocument(new FileInputStream(file));
                                    Notify notify = WSNotificationReader.getInstance().readNotify(doc);
                                    NotificationStorageService.this.sender.send(notify, NotificationStorageService.this.getConsumerReference());
                                    boolean deleted = FileUtils.deleteQuietly(file);
                                    if (deleted) continue;
                                    NotificationStorageService.this.moveToTrash(file);
                                    continue;
                                }
                                NotificationStorageService.this.logger.fine("File '" + file.getAbsolutePath() + "' does not exists for ID " + fileName);
                                continue;
                            }
                            NotificationStorageService.this.logger.fine("Can't process persisted notifications if the publisher isn't registered. Retry later");
                        }
                        catch (Exception e) {
                            if (!NotificationStorageService.this.logger.isLoggable(Level.FINE)) continue;
                            NotificationStorageService.this.logger.log(Level.FINE, "An error occured during persisted notification processing", e);
                        }
                    }
                } else {
                    NotificationStorageService.this.logger.fine("No persisted notification to process. Stop persisted notification processor.");
                    NotificationStorageService.this.stop();
                }
            }
        };
        this.logger.info("Storage Service is now running to process persisted notifications");
        this.executor.scheduleAtFixedRate(runnable, 120L, 120L, TimeUnit.SECONDS);
    }

    protected EndpointReferenceType getConsumerReference() {
        return this.notificationContext.getConsumerReference();
    }

    public void stop() {
        if (!LifeCyle.STATE.STOPPED.equals((Object)this.state)) {
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.executor = null;
            }
            try {
                FileUtils.cleanDirectory(this.trashFolder);
            }
            catch (IOException e) {
                this.logger.warning("Notification trash folder can't be cleaned. Will be cleaned later");
            }
            this.state = LifeCyle.STATE.STOPPED;
        }
    }
}

