/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.process.JBIProcessorThreadFactory;
import org.ow2.petals.component.framework.process.MessageExchangeProcessorObjectFactory;
import org.ow2.petals.component.framework.process.MessageExchangeProcessorThreadPoolExecutor;

public class JBIProcessorManager
implements NotificationListener {
    public static final int DEFAULT_PROCESSOR_POOL_SIZE_MAX = 50;
    protected static final int DEFAULT_PROCESSOR_POOL_SIZE_KEEP_ALIVE_TIME = 60;
    private ThreadPoolExecutor processorPool = null;
    private GenericObjectPool messageProcessorPool = null;
    private final AbstractComponent component;
    private final RuntimeConfigurationNotifier runtimeConfiguration;
    private final Logger logger;

    public JBIProcessorManager(AbstractComponent component, RuntimeConfigurationNotifier runtimeConfiguration, Logger logger) {
        this.component = component;
        this.runtimeConfiguration = runtimeConfiguration;
        this.logger = logger;
    }

    public void init() throws JBIException {
        this.runtimeConfiguration.addNotificationListener(this, null, null);
    }

    public void shutdown() throws JBIException {
        try {
            this.runtimeConfiguration.removeNotificationListener(this, null, null);
        }
        catch (ListenerNotFoundException e) {
            throw new JBIException("Error unregistering the runtime configuration listener", (Throwable)e);
        }
    }

    public void start() throws JBIException {
        int msgProcessorMaxPoolSize;
        this.logger.fine("Creating JBI Processor pool:");
        int coreProcessorPoolSize = this.component.getComponentConfiguration().getProcessorPoolSize().getValue();
        int maxProcessorPoolSize = this.component.getComponentConfiguration().getProcessorMaxPoolSize() != null ? this.component.getComponentConfiguration().getProcessorMaxPoolSize().getValue() : 50;
        if (coreProcessorPoolSize > maxProcessorPoolSize) {
            int previousMax = maxProcessorPoolSize;
            maxProcessorPoolSize = coreProcessorPoolSize;
            this.logger.warning("The value of 'processor-pool-size' (" + coreProcessorPoolSize + ") is invalid, greater than 'processor-max-pool-size' (" + previousMax + "). The value of 'processor-max-pool-size' is set to the value of 'processor-pool-size'");
        }
        int processorPoolKeepAlive = this.component.getComponentConfiguration().getProcessorKeepAliveTime() != null ? this.component.getComponentConfiguration().getProcessorKeepAliveTime().getValue() : 60;
        if (this.component.getComponentConfiguration().getMessageProcessorMaxPoolSize() != null) {
            msgProcessorMaxPoolSize = this.component.getComponentConfiguration().getMessageProcessorMaxPoolSize().getValue();
            if (msgProcessorMaxPoolSize <= 0) {
                this.logger.warning("The value of 'message-processor-max-pool-size' (" + msgProcessorMaxPoolSize + ") is invalid. The value must be strictly upper to 0.");
                msgProcessorMaxPoolSize = maxProcessorPoolSize;
            }
        } else {
            msgProcessorMaxPoolSize = maxProcessorPoolSize;
        }
        if (msgProcessorMaxPoolSize < maxProcessorPoolSize) {
            int previousMax = msgProcessorMaxPoolSize;
            msgProcessorMaxPoolSize = maxProcessorPoolSize;
            this.logger.warning("The value of 'message-processor-max-pool-size' (" + previousMax + ") is invalid, lower than 'processor-max-pool-size' (" + maxProcessorPoolSize + "). The value of 'message-processor-max-pool-size' is set to the value of 'processor-max-pool-size'");
        }
        this.logger.fine("\t- core pool size: " + coreProcessorPoolSize);
        this.logger.fine("\t- max core pool size: " + maxProcessorPoolSize);
        this.logger.fine("\t- keep alive time: " + processorPoolKeepAlive);
        this.logger.fine("\t- message processoir max pool size: " + msgProcessorMaxPoolSize);
        this.messageProcessorPool = new GenericObjectPool((PoolableObjectFactory)new MessageExchangeProcessorObjectFactory(this.component, this.logger), msgProcessorMaxPoolSize, 0, -1L, 8, coreProcessorPoolSize, false, false, 600000L, -33, (long)processorPoolKeepAlive, false);
        try {
            PoolUtils.prefill((ObjectPool)this.messageProcessorPool, (int)coreProcessorPoolSize);
        }
        catch (IllegalArgumentException e) {
            throw new JBIException((Throwable)e);
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
        this.processorPool = new MessageExchangeProcessorThreadPoolExecutor(coreProcessorPoolSize, maxProcessorPoolSize, processorPoolKeepAlive, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new JBIProcessorThreadFactory(this.component, this.logger), this.messageProcessorPool, this.logger);
        this.processorPool.prestartAllCoreThreads();
    }

    public void stop() {
        this.processorPool.shutdown();
        try {
            long processorStopMaxWait = 15000L;
            if (this.component.getComponentConfiguration().getProcessorStopMaxWait() != null) {
                processorStopMaxWait = this.component.getComponentConfiguration().getProcessorStopMaxWait().getValue();
            }
            this.processorPool.awaitTermination(processorStopMaxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Stop of workers pool was interrupted : " + e.getMessage());
        }
        this.processorPool.shutdownNow();
        try {
            this.messageProcessorPool.close();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to close the Messsage Exchange Processor Object pool properly", e);
        }
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.processorPool;
    }

    public GenericObjectPool getObjectPool() {
        return this.messageProcessorPool;
    }

    private void setPoolKeepAliveTime(int time) {
        this.logger.info("Reset the processor thread pool keep alive time to " + time);
        try {
            this.processorPool.setKeepAliveTime(time, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            this.logger.warning("Invalid value used (less than or equal to zero) to configure the processor thread pool keep alive time: " + time);
        }
    }

    private void setMaxCorePoolSize(int size) {
        this.logger.info("Reset the maximum processor thread pool size to " + size);
        try {
            this.processorPool.setMaximumPoolSize(size);
            this.messageProcessorPool.setMaxActive(size);
        }
        catch (IllegalArgumentException e) {
            this.logger.warning("Invalid value used (less than or equal to zero, or less than the core pool size) to configure the processor thread pool max size: " + size);
        }
    }

    private void setCorePoolSize(int size) {
        this.logger.info("Reset the processor thread pool size to " + size);
        try {
            this.processorPool.setCorePoolSize(size);
            this.messageProcessorPool.setMinIdle(size);
        }
        catch (IllegalArgumentException e) {
            this.logger.warning("Invalid value used (less than or equal to zero) to configure the processor thread pool core size: " + size);
        }
    }

    protected void setMessageProcessorMaxPoolSize(int size) {
        this.logger.info("Reset the message processor max pool size to " + size);
        if (size <= 0) {
            String warningMessage = String.format("Invalid value used (less than or equal to zero) to configure the message processor max pool size: %d", size);
            this.logger.warning(warningMessage);
        } else if (size < this.processorPool.getMaximumPoolSize()) {
            String warningMessage = String.format("Invalid value used (lower than the processor thread pool max size: %d) to configure the message processor max pool size: %d", this.processorPool.getMaximumPoolSize(), size);
            this.logger.warning(warningMessage);
        } else {
            this.messageProcessorPool.setMaxActive(size);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object obj) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification attrNotif = (AttributeChangeNotification)notification;
            String attrName = attrNotif.getAttributeName();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Notification received by " + this.getClass().getName() + " for attribute : " + attrName);
            }
            if (attrName.equals("processorPoolSize")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setCorePoolSize(newVal);
            } else if (attrName.equals("processorMaxPoolSize")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setMaxCorePoolSize(newVal);
            } else if (attrName.equals("processorKeepAliveTime")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setPoolKeepAliveTime(newVal);
            } else if (attrNotif.getAttributeName().equals("messageProcessorMaxPoolSize")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setMessageProcessorMaxPoolSize(newVal);
            } else {
                this.logger.log(Level.FINE, "Notification ignored by " + this.getClass().getName() + " for attribute : " + attrName);
            }
        }
    }
}

