/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.NoSuchElementException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;

public class MessageExchangeAcceptor
extends Thread {
    private Logger logger;
    private DeliveryChannel deliveryChannel;
    private volatile boolean running = false;
    private Object runningLock = new Object();
    private ThreadPoolExecutor jbiProcessorThreadPool;
    private GenericObjectPool jbiProcessorObjectPool;
    private final int nbMaxTry;
    private final long baseWaitDuration;

    public MessageExchangeAcceptor(AbstractComponent component, ThreadPoolExecutor jbiProcessorThreadPool, GenericObjectPool jbiProcessorObjectPool, Logger logger, ThreadGroup threadGroup, String threadName, int nbMaxTry, long baseWaitDuration) {
        super(threadGroup, threadName);
        this.jbiProcessorThreadPool = jbiProcessorThreadPool;
        this.jbiProcessorObjectPool = jbiProcessorObjectPool;
        this.deliveryChannel = component.getChannel();
        this.nbMaxTry = nbMaxTry;
        this.baseWaitDuration = baseWaitDuration;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.log(Level.FINE, "Starting MessageExchangeAcceptor Thread " + this.getName());
        this.running = true;
        block11: while (this.running) {
            try {
                ExchangeImpl exchange = new ExchangeImpl(this.deliveryChannel.accept());
                this.logger.fine("Accepting a JBI message with Id : " + exchange.getExchangeId());
                int nbTry = 0;
                long waitDuration = 0L;
                for (int i = 0; i < this.nbMaxTry; ++i) {
                    try {
                        MessageExchangeProcessor messageExchangeProcessor = (MessageExchangeProcessor)this.jbiProcessorObjectPool.borrowObject();
                        if (messageExchangeProcessor == null) {
                            throw new NoSuchElementException("No more JBI message exchange processor is available in the pool.");
                        }
                        messageExchangeProcessor.setMessageExchange(exchange);
                        try {
                            this.jbiProcessorThreadPool.execute(messageExchangeProcessor);
                            continue block11;
                        }
                        catch (RejectedExecutionException e) {
                            messageExchangeProcessor.clean();
                            this.jbiProcessorObjectPool.returnObject((Object)messageExchangeProcessor);
                            throw e;
                        }
                    }
                    catch (NoSuchElementException e) {
                        if (nbTry == this.nbMaxTry) {
                            this.logger.warning("Try #" + i + ". No more JBI message exchange processor is available in the pool, and the try number is reached. Message discarded.");
                            continue;
                        }
                        waitDuration = waitDuration + this.baseWaitDuration * (long)(i + 1) + (long)(10.0 * Math.random());
                        this.logger.warning("Try #" + i + ". No JBI message exchange processor is available in the pool. Wait " + waitDuration + "ms before next try.");
                        Thread.sleep(waitDuration);
                        continue;
                    }
                    catch (RejectedExecutionException e) {
                        if (nbTry == this.nbMaxTry) {
                            this.logger.warning("Try #" + i + ". No more thread is available to execute a JBI message exchange processor, and the try number is reached. Message discarded.");
                            continue;
                        }
                        waitDuration = waitDuration + this.baseWaitDuration * (long)(i + 1) + (long)(10.0 * Math.random());
                        this.logger.warning("Try #" + i + ". No thread is available to execute a JBI message exchange processor. Wait " + waitDuration + "ms before next try.");
                        Thread.sleep(waitDuration);
                    }
                }
            }
            catch (PEtALSCDKException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Throwable e) {
                Object object = this.runningLock;
                synchronized (object) {
                    for (Throwable cause = e; cause != null && this.running; cause = cause.getCause()) {
                        if (!(cause instanceof InterruptedException)) continue;
                        this.running = false;
                        this.logger.fine("Thread '" + this.getName() + "' interrupted, stop accepting JBI messages");
                    }
                }
                if (!this.running) continue;
                this.logger.log(Level.INFO, "An unexpected exception occurs during the processing of the JBI acceptor '" + this.getName() + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ends() {
        Object object = this.runningLock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                this.logger.fine("Thread '" + this.getName() + "' will stop to accept JBI messages.");
            }
        }
    }
}

