/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.commons.util.IDGenerator;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.exception.SOAP11FaultServerException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.ExchangeProperties;
import org.ow2.petals.component.framework.jbidescriptor.generated.IgnoreStatus;
import org.ow2.petals.component.framework.jbidescriptor.generated.MessageParam;
import org.ow2.petals.component.framework.jbidescriptor.generated.MessageProperties;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.notification.notify.FaultProducerComponentNotify;
import org.ow2.petals.component.framework.notification.notify.InProducerComponentNotify;
import org.ow2.petals.component.framework.notification.notify.OutProducerComponentNotify;
import org.ow2.petals.component.framework.notification.notify.StatusProducerComponentNotify;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.process.async.AsyncMessageManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.UtilFactory;

public class MessageExchangeProcessor
implements Runnable {
    private final AbstractComponent component;
    private final Logger logger;
    private final DeliveryChannel deliveryChannel;
    private final Object transactionManager;
    private final AbstractJBIListener jbiListener;
    private final AbstractServiceUnitManager suManager;
    private final AsyncMessageManager asyncManager;
    private final String componentName;
    private final IgnoreStatus ignoreStatus;
    private ExchangeImpl exchange = null;

    public MessageExchangeProcessor(AbstractComponent component, AbstractJBIListener jbiListener, Logger logger) {
        this.component = component;
        this.jbiListener = jbiListener;
        this.logger = logger;
        this.deliveryChannel = component.getChannel();
        this.suManager = (AbstractServiceUnitManager)component.getServiceUnitManager();
        this.asyncManager = component.getAsyncManager();
        this.transactionManager = component.getContext().getTransactionManager();
        this.componentName = component.getContext().getComponentName();
        this.ignoreStatus = component.getComponentConfiguration().getIgnoredStatus();
    }

    public void setMessageExchange(ExchangeImpl exchange) {
        this.exchange = exchange;
    }

    @Override
    public void run() {
        block7: {
            if (!this.isIgnored(this.exchange)) {
                try {
                    this.process(this.exchange);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                    if (!this.exchange.isActiveStatus()) break block7;
                    try {
                        if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern())) {
                            this.exchange.setFault(e);
                        } else {
                            this.exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)e))));
                        }
                        this.deliveryChannel.send(this.exchange.getMessageExchange());
                    }
                    catch (MessagingException e1) {
                        this.logger.log(Level.SEVERE, "Cannot send back an error acknowledgement or a Fault", e);
                    }
                }
            }
        }
    }

    protected final void clean() {
        this.jbiListener.setConsumes(null);
        this.jbiListener.setProvides(null);
        this.jbiListener.setExtensions(null);
        this.jbiListener.setCurrentTransaction(null);
        this.exchange = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void process(Exchange exchange) throws MessagingException {
        this.setCurrentTransaction();
        if (exchange.isProviderRole()) {
            try {
                this.processAsProvider(exchange);
                return;
            }
            catch (RuntimeException e) {
                if (!exchange.isProviderRole()) return;
                throw e;
            }
            catch (MessagingException e) {
                if (!exchange.isProviderRole()) return;
                throw e;
            }
        }
        try {
            this.processAsConsumer(exchange);
            return;
        }
        catch (RuntimeException e) {
            if (!exchange.isConsumerRole()) return;
            throw e;
        }
        catch (MessagingException e) {
            if (!exchange.isConsumerRole()) return;
            throw e;
        }
    }

    private final void processAsConsumer(Exchange exchange) throws MessagingException {
        AsyncContext asyncContext = null;
        this.logger.finest("Process an exchange as CONSUMER with id : " + exchange.getExchangeId());
        Consumes consumes = this.getConsumesFromExchange(exchange);
        if (consumes != null) {
            this.jbiListener.setConsumes(consumes);
            this.jbiListener.setExtensions(this.getExtensions(consumes));
            try {
                this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, consumes, Message.InterceptorPhase.SEND_RESPONSE);
            }
            catch (PEtALSCDKException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        if (this.exchange.getProperty("org.ow2.petals.component.framework.asynchronous") != null) {
            asyncContext = this.asyncManager.getAsyncContext(this.exchange.getExchangeId());
            if (asyncContext == null && exchange.isActiveStatus()) {
                exchange.setError(new Exception("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!"));
                this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
            }
        } else if (this.exchange.getProperty("org.ow2.petals.component.framework.asynchronous.original") != null) {
            asyncContext = this.asyncManager.removeAsyncContext(this.exchange.getExchangeId());
        } else {
            this.logger.fine("The exchange '" + exchange.getExchangeId() + "' refers to an unknown consumer on the component : " + this.componentName + ". The listener will not have the consumes and the extensions for this exchange");
        }
        if (exchange.isInOnlyPattern()) {
            this.processInOnlyAsConsumer(exchange, asyncContext);
        } else if (exchange.isRobustInOnlyPattern()) {
            this.processRobustInOnlyAsConsumer(exchange, asyncContext);
        } else if (exchange.isInOutPattern()) {
            this.processInOutAsConsumer(exchange, asyncContext);
        } else if (exchange.isInOptionalOutPattern()) {
            this.processInOptionalOutAsConsumer(exchange, asyncContext);
        } else {
            throw new MessagingException("Message Exchange Pattern not recognized :" + exchange.getPattern());
        }
    }

    private final void processAsProvider(Exchange exchange) throws MessagingException {
        this.logger.finest("Process an exchange as PROVIDER with id : " + exchange.getExchangeId());
        Provides provides = this.getProvidesFromExchange(exchange);
        if (provides == null) {
            if (this.component.getServiceDescription(exchange.getEndpoint()) == null) {
                throw new MessagingException("The endpoint '" + exchange.getEndpoint() + "' is unknown on the component : " + this.componentName);
            }
            this.logger.fine("Process an exchange managed directly by the component");
        } else {
            this.jbiListener.setProvides(provides);
            this.jbiListener.setExtensions(this.getExtensions(provides));
            try {
                this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT);
            }
            catch (PEtALSCDKException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        AsyncContext asyncContext = null;
        if (this.exchange.getProperty("org.ow2.petals.component.framework.asynchronous.expired") != null) {
            asyncContext = this.asyncManager.removeAsyncContext(this.exchange.getExchangeId());
        }
        if (exchange.getProperty("org.ow2.petals.propagate.correlation") == null) {
            String correlationId = IDGenerator.getInstance().getNewID();
            exchange.setProperty("org.ow2.petals.propagate.correlation", (Object)correlationId);
        }
        ((ExchangeImpl)exchange).setCheckRole(false);
        if (this.component.getNotificationBrokerController() != null && !UtilFactory.getExchangeUtil().isBaseNotification(exchange)) {
            this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(InProducerComponentNotify.class, exchange);
        }
        ((ExchangeImpl)exchange).setCheckRole(true);
        if (exchange.isInOnlyPattern()) {
            this.processInOnlyAsProvider(exchange, asyncContext, provides);
        } else if (exchange.isRobustInOnlyPattern()) {
            this.processRobustInOnlyAsProvider(exchange, asyncContext, provides);
        } else if (exchange.isInOutPattern()) {
            this.processInOutAsProvider(exchange, asyncContext, provides);
        } else if (exchange.isInOptionalOutPattern()) {
            this.processInOptionalOutAsProvider(exchange, asyncContext, provides);
        } else {
            throw new MessagingException("Message Exchange Pattern not recognized :" + exchange.getPattern());
        }
    }

    private final void processInOnlyAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        if (UtilFactory.getExchangeUtil().isBaseNotification(exchange)) {
            if (asyncContext == null) {
                this.jbiListener.onNotificationMessage(exchange);
            } else {
                this.jbiListener.onAsyncNotificationMessage(exchange, asyncContext);
            }
        } else if (asyncContext == null) {
            this.jbiListener.onJBIMessage(exchange);
        } else {
            this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
    }

    private final void processInOnlyAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean reply = false;
        reply = UtilFactory.getExchangeUtil().isBaseNotification(exchange) ? (asyncContext == null ? this.jbiListener.onNotificationMessage(exchange) : this.jbiListener.onExpiredAsyncNotificationMessage(exchange, asyncContext)) : (asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext));
        if (reply) {
            if (exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException e) {
                    throw new MessagingException((Throwable)e);
                }
                this.setProperties(provides);
            }
            if (this.component.getNotificationBrokerController() != null && !UtilFactory.getExchangeUtil().isBaseNotification(exchange)) {
                this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(StatusProducerComponentNotify.class, exchange);
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOptionalOutAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        boolean reply = false;
        boolean doneOrErrorStatusReceived = false;
        if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
            doneOrErrorStatusReceived = true;
        }
        reply = UtilFactory.getExchangeUtil().isBaseNotification(exchange) ? (asyncContext == null ? this.jbiListener.onNotificationMessage(exchange) : this.jbiListener.onAsyncNotificationMessage(exchange, asyncContext)) : (asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onAsyncJBIMessage(exchange, asyncContext));
        if (reply && !doneOrErrorStatusReceived) {
            if (exchange.getFault() == null && exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOptionalOutAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean reply = false;
        boolean faultReceived = false;
        boolean doneOrErrorStatusReceived = false;
        if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
            doneOrErrorStatusReceived = true;
        } else if (exchange.getFault() != null) {
            faultReceived = true;
        }
        reply = UtilFactory.getExchangeUtil().isBaseNotification(exchange) ? (asyncContext == null ? this.jbiListener.onNotificationMessage(exchange) : this.jbiListener.onExpiredAsyncNotificationMessage(exchange, asyncContext)) : (asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext));
        if (provides != null && exchange.isOutMessage()) {
            MessageExchangeProcessor.forwardMessageData(exchange, provides);
        }
        if (reply) {
            if (!doneOrErrorStatusReceived && exchange.isActiveStatus() && (faultReceived || exchange.getFault() == null && !((ExchangeImpl)exchange).isOutMessage())) {
                exchange.setDoneStatus();
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException e) {
                    throw new MessagingException((Throwable)e);
                }
                this.setProperties(provides);
            }
            if (!doneOrErrorStatusReceived) {
                if (this.component.getNotificationBrokerController() != null && !UtilFactory.getExchangeUtil().isBaseNotification(exchange)) {
                    if (exchange.isActiveStatus()) {
                        if (exchange.getFault() == null) {
                            this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(OutProducerComponentNotify.class, exchange);
                        } else {
                            this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(FaultProducerComponentNotify.class, exchange);
                        }
                    } else {
                        this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(StatusProducerComponentNotify.class, exchange);
                    }
                }
                this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
            } else {
                this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(StatusProducerComponentNotify.class, exchange);
            }
        }
    }

    private final void processInOutAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        boolean reply = false;
        reply = UtilFactory.getExchangeUtil().isBaseNotification(exchange) ? (asyncContext == null ? this.jbiListener.onNotificationMessage(exchange) : this.jbiListener.onAsyncNotificationMessage(exchange, asyncContext)) : (asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onAsyncJBIMessage(exchange, asyncContext));
        if (reply) {
            if (exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOutAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean doneOrErrorStatusReceived;
        boolean reply;
        block14: {
            reply = false;
            doneOrErrorStatusReceived = false;
            try {
                if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
                    doneOrErrorStatusReceived = true;
                }
                reply = UtilFactory.getExchangeUtil().isBaseNotification(exchange) ? (asyncContext == null ? this.jbiListener.onNotificationMessage(exchange) : this.jbiListener.onExpiredAsyncNotificationMessage(exchange, asyncContext)) : (asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext));
                if (provides != null && exchange.isOutMessage()) {
                    MessageExchangeProcessor.forwardMessageData(exchange, provides);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "An unexpected exception occured during an exchange processing", e);
                if (exchange.getFault() != null) break block14;
                exchange.setFault((Throwable)new SOAP11FaultServerException(e.getMessage(), Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName), (Throwable)e));
                reply = true;
            }
        }
        if (reply && !doneOrErrorStatusReceived) {
            if (exchange.getFault() == null && !exchange.isOutMessage()) {
                if (exchange.getError() != null) {
                    exchange.setFault((Throwable)new SOAP11FaultServerException(exchange.getError().getMessage(), Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName), (Throwable)exchange.getError()));
                } else {
                    exchange.setFault((Throwable)new SOAP11FaultServerException("The Provider do not return any response", Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName)));
                }
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException e) {
                    throw new MessagingException((Throwable)e);
                }
                this.setProperties(provides);
            }
            if (this.component.getNotificationBrokerController() != null && !UtilFactory.getExchangeUtil().isBaseNotification(exchange)) {
                if (exchange.getFault() == null) {
                    this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(OutProducerComponentNotify.class, exchange);
                } else {
                    this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(FaultProducerComponentNotify.class, exchange);
                }
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processRobustInOnlyAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        if (UtilFactory.getExchangeUtil().isBaseNotification(exchange)) {
            if (asyncContext == null) {
                this.jbiListener.onNotificationMessage(exchange);
            } else {
                this.jbiListener.onAsyncNotificationMessage(exchange, asyncContext);
            }
        } else if (asyncContext == null) {
            this.jbiListener.onJBIMessage(exchange);
        } else {
            this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
    }

    private final void processRobustInOnlyAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean reply = false;
        boolean doneOrErrorStatusReceived = false;
        if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
            doneOrErrorStatusReceived = true;
        }
        reply = UtilFactory.getExchangeUtil().isBaseNotification(exchange) ? (asyncContext == null ? this.jbiListener.onNotificationMessage(exchange) : this.jbiListener.onExpiredAsyncNotificationMessage(exchange, asyncContext)) : (asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext));
        if (reply && !doneOrErrorStatusReceived) {
            if (exchange.getFault() == null && exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException e) {
                    throw new MessagingException((Throwable)e);
                }
                this.setProperties(provides);
            }
            if (this.component.getNotificationBrokerController() != null && !UtilFactory.getExchangeUtil().isBaseNotification(exchange)) {
                Object notify = null;
                if (exchange.isActiveStatus()) {
                    if (exchange.getFault() == null) {
                        this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(OutProducerComponentNotify.class, exchange);
                    } else {
                        this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(FaultProducerComponentNotify.class, exchange);
                    }
                } else {
                    this.component.getNotificationBrokerController().getNotificationProducer().getNotifyController().process(StatusProducerComponentNotify.class, exchange);
                }
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final ConfigurationExtensions getExtensions(Object service) {
        ConfigurationExtensions extensions = null;
        if (service == null) {
            return null;
        }
        ServiceUnitDataHandler suDataHandler = this.suManager.getSUDataHandlerForService(service);
        if (suDataHandler != null) {
            extensions = suDataHandler.getConfigurationExtensions(service);
        }
        return extensions;
    }

    private final Consumes getConsumesFromExchange(Exchange exchange) {
        ServiceEndpoint endpoint = exchange.getEndpoint();
        return this.suManager.getConsumesFromDestination(endpoint.getEndpointName(), exchange.getService(), exchange.getInterfaceName());
    }

    private final Provides getProvidesFromExchange(Exchange exchange) {
        ServiceEndpoint ep = exchange.getEndpoint();
        Provides provides = this.suManager.getProvidesFromEndpoint(ep);
        return provides;
    }

    private final void setCurrentTransaction() {
        if (this.exchange.isTransacted()) {
            Transaction currentTransaction = (Transaction)this.exchange.getProperty("javax.jbi.transaction.jta");
            if (currentTransaction == null) {
                try {
                    currentTransaction = ((TransactionManager)this.transactionManager).getTransaction();
                }
                catch (SystemException e) {
                    this.logger.log(Level.WARNING, "Failed to retrieve Transaction for exchange '" + this.exchange.getExchangeId() + "'", e);
                }
            }
            this.jbiListener.setCurrentTransaction(currentTransaction);
        }
    }

    private final void setProperties(Provides provides) throws MessagingException {
        MessageProperties messageProperties;
        ExchangeProperties exchangeProperties = provides.getExchangeProperties();
        if (exchangeProperties != null) {
            for (Param exchangeProperty : exchangeProperties.getExchangeProperty()) {
                this.exchange.setProperty(exchangeProperty.getName(), exchangeProperty.getValue());
            }
        }
        if ((messageProperties = provides.getMessageProperties()) != null) {
            for (MessageParam messageProperty : messageProperties.getMessageProperty()) {
                NormalizedMessage message = this.exchange.getMessageExchange().getMessage(messageProperty.getMessage().name());
                message.setProperty(messageProperty.getName(), (Object)messageProperty.getValue());
            }
        }
    }

    private final boolean isIgnored(Exchange exchange) {
        boolean result = false;
        if (exchange.isDoneStatus()) {
            result = IgnoreStatus.DONE_IGNORED == this.ignoreStatus || IgnoreStatus.DONE_AND_ERROR_IGNORED == this.ignoreStatus;
        } else if (exchange.isErrorStatus()) {
            result = IgnoreStatus.ERROR_IGNORED == this.ignoreStatus || IgnoreStatus.DONE_AND_ERROR_IGNORED == this.ignoreStatus;
        }
        return result;
    }

    private static final void forwardMessageData(Exchange exchange, Provides provides) throws MessagingException {
        if (provides == null) {
            return;
        }
        if (provides.isForwardSecuritySubject() != null && provides.isForwardSecuritySubject().booleanValue() && exchange.getInSubject() != null && exchange.getOutSubject() == null) {
            exchange.setOutSubject(exchange.getInSubject());
        }
        if (provides.isForwardMessageProperties() != null && provides.isForwardMessageProperties().booleanValue()) {
            for (String propertyName : exchange.getInMessagePropertyNames()) {
                if (exchange.getOutMessageProperty(propertyName) != null) continue;
                exchange.setOutMessageProperty(propertyName, exchange.getInMessageProperty(propertyName));
            }
        }
        if (provides.isForwardAttachments() != null && provides.isForwardAttachments().booleanValue()) {
            Set attachmentNames = exchange.getInMessageAttachmentNames();
            for (String attachmentName : attachmentNames) {
                if (exchange.getOutMessageAttachment(attachmentName) != null) continue;
                exchange.setOutMessageAttachment(attachmentName, exchange.getInMessageAttachment(attachmentName));
            }
        }
    }
}

