/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;

public class MessageExchangeProcessorThreadPoolExecutor
extends ThreadPoolExecutor {
    private final GenericObjectPool messageProcessorPool;
    private final Logger logger;

    public MessageExchangeProcessorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, GenericObjectPool objectPool, Logger logger) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
        this.messageProcessorPool = objectPool;
        this.logger = logger;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ((MessageExchangeProcessor)r).clean();
        try {
            this.messageProcessorPool.returnObject((Object)r);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to return a Message Exchange Processor instance to the Object pool", e);
        }
        super.afterExecute(r, t);
    }
}

