/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import javax.xml.parsers.ParserConfigurationException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.util.ExchangeUtil;
import org.ow2.petals.component.framework.api.util.SourceUtil;
import org.ow2.petals.component.framework.api.util.WSDLUtil;
import org.ow2.petals.component.framework.api.util.XSLTUtil;
import org.ow2.petals.component.framework.util.ExchangeUtilImpl;
import org.ow2.petals.component.framework.util.SourceUtilImpl;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.ow2.petals.component.framework.util.XSLTUtilImpl;

public class UtilFactory {
    private static ExchangeUtil exchangeUtil = null;
    private static WSDLUtil wsdlUtil = null;
    private static XSLTUtil xsltUtil = null;
    private static SourceUtil sourceUtil = null;
    private static WSDLException wsdlUtilException = null;
    private static ParserConfigurationException xsltUtilException = null;

    public static ExchangeUtil getExchangeUtil() {
        return exchangeUtil;
    }

    public static WSDLUtil getWSDLUtil() throws WSDLException {
        if (wsdlUtil == null) {
            throw wsdlUtilException;
        }
        return wsdlUtil;
    }

    public static SourceUtil getSourceUtil() {
        return sourceUtil;
    }

    public static XSLTUtil getXSLTUtil() throws ParserConfigurationException {
        if (xsltUtil == null) {
            throw xsltUtilException;
        }
        return xsltUtil;
    }

    public static void close() {
        exchangeUtil = null;
        sourceUtil = null;
        xsltUtil = null;
        xsltUtilException = null;
        wsdlUtil = null;
        wsdlUtilException = null;
    }

    static {
        exchangeUtil = new ExchangeUtilImpl();
        sourceUtil = new SourceUtilImpl();
        try {
            xsltUtil = new XSLTUtilImpl();
        }
        catch (ParserConfigurationException e) {
            xsltUtilException = e;
        }
        try {
            wsdlUtil = new WSDLUtilImpl();
        }
        catch (WSDLException e) {
            wsdlUtilException = e;
        }
    }
}

