/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public final class IDGenerator {
    private static final String UUID_NAMESPACE = "petals:uid:";
    public static final int RANDOM_VALUE_SIZE = 18;
    public static final int UUID_SIZE;
    private static final IDGenerator instance;
    private final String prefix;
    private long value = 0L;
    private final Object valueLock = new Object();

    private IDGenerator(String prefix) {
        this.prefix = prefix;
    }

    public static IDGenerator getInstance() {
        return instance;
    }

    public String getNewID() {
        return this.getNewID(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewID(boolean prefixNS) {
        long tmp;
        Object object = this.valueLock;
        synchronized (object) {
            tmp = ++this.value;
            if (this.value >= Long.MAX_VALUE) {
                this.value = 0L;
            }
        }
        StringBuilder builder = new StringBuilder(UUID_SIZE);
        if (prefixNS) {
            builder.append(UUID_NAMESPACE);
        }
        return builder.append(this.prefix).append(System.nanoTime()).append(tmp).toString();
    }

    static {
        byte[] array;
        String sid;
        UUID_SIZE = UUID_NAMESPACE.length() + 18 + String.valueOf(System.nanoTime()).length() + Long.toString(Long.MAX_VALUE).length();
        Random myRand = new Random();
        long rand = myRand.nextLong();
        try {
            sid = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            sid = Thread.currentThread().getName();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(sid);
        sb.append(":");
        sb.append(Long.toString(rand));
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(sb.toString().getBytes());
            array = md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            array = sb.toString().getBytes();
        }
        StringBuffer sb2 = new StringBuffer();
        for (int j = 0; j < array.length; ++j) {
            int b = array[j] & 0xFF;
            sb2.append(Integer.toHexString(b));
        }
        int begin = myRand.nextInt();
        if (begin < 0) {
            begin *= -1;
        }
        instance = new IDGenerator(sb2.toString().substring(begin %= 8, begin + 18).toUpperCase());
    }
}

