/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.service.provide;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.ow2.petals.bc.mail.MailSessionManager;
import org.ow2.petals.bc.mail.MailUtil;
import org.ow2.petals.bc.mail.MimeMessageManager;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.service.provide.AbstractSendService;
import org.ow2.petals.bc.mail.service.provide.ProvideDescriptor;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Node;

public class SuSendService
extends AbstractSendService {
    private final ConfigurationExtensions extensions;

    public SuSendService(MailSessionManager mailSessionManager, MimeMessageManager mimeMessageManager, Logger logger, ConfigurationExtensions extensions) {
        super(mailSessionManager, mimeMessageManager, logger);
        this.extensions = extensions;
    }

    @Override
    public void sendMail(Exchange exchange) throws javax.jbi.messaging.MessagingException, MissingElementException {
        try {
            this.logger.log(Level.INFO, "JBI Exchange received - send it as a mail");
            ProvideDescriptor provideDescriptor = MailUtil.build(this.extensions);
            Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(provideDescriptor);
            Node rootNode = exchange.getInMessageContentAsDocument(false).getFirstChild();
            if (rootNode == null || !rootNode.getLocalName().equalsIgnoreCase("mail")) {
                throw new MissingElementException("mail");
            }
            MimeMessage mimeMessage = this.mimeMessageManager.mapNormalizedMessageToMimeMessage(session, provideDescriptor, exchange, rootNode);
            this.mailSessionManager.sendMail(mimeMessage, provideDescriptor, session);
            this.logger.log(Level.INFO, "email sent to " + provideDescriptor.getToAddress());
        }
        catch (MessagingException e) {
            throw new javax.jbi.messaging.MessagingException((Throwable)e);
        }
    }
}

