/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.service.consume;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import java.util.List;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.ow2.petals.bc.mail.MailConsumeFlowStepBeginLogData;
import org.ow2.petals.bc.mail.MailSessionManager;
import org.ow2.petals.bc.mail.listeners.ExternalListener;
import org.ow2.petals.bc.mail.service.consume.ConsumeDescriptor;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.LoggingUtil;

public class ExternalEventPoller
extends TimerTask {
    private static final SimpleUUIDGenerator simpleUUIDGenerator = new SimpleUUIDGenerator();
    private final transient ExternalListener externalListener;
    protected final transient Logger logger;
    protected transient MailSessionManager mailSessionManager;
    protected transient Consumes consumes;
    protected transient ConsumeDescriptor consumeDescriptor;

    public ExternalEventPoller(Logger log, ExternalListener externalListener, Consumes consumes, ConsumeDescriptor consumeDescriptor, MailSessionManager mailSessionManager) {
        this.logger = log;
        this.externalListener = externalListener;
        this.mailSessionManager = mailSessionManager;
        this.consumes = consumes;
        this.consumeDescriptor = consumeDescriptor;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Message> messages = null;
        Folder folder = null;
        Store store = null;
        try {
            Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(this.consumeDescriptor);
            store = this.mailSessionManager.getStoreAndConnect(session, this.consumeDescriptor);
            folder = this.mailSessionManager.getFolderAndOpen(store, this.consumeDescriptor);
            messages = this.mailSessionManager.getNewMails(folder);
            for (Message message : messages) {
                try {
                    PetalsExecutionContext.putFlowInstanceId((String)simpleUUIDGenerator.getNewID());
                    PetalsExecutionContext.putFlowStepId((String)simpleUUIDGenerator.getNewID());
                    String flowInstanceId = ExecutionContext.getProperties().getProperty("flowInstanceId");
                    String flowStepId = ExecutionContext.getProperties().getProperty("flowStepId");
                    this.getLogger().log(Level.MONIT, "", (Object)new MailConsumeFlowStepBeginLogData(flowInstanceId, flowStepId, StringHelper.nonNullValue((Object)this.consumes.getInterfaceName()), StringHelper.nonNullValue((Object)this.consumes.getServiceName()), this.consumes.getEndpointName(), StringHelper.nonNullValue((Object)this.consumes.getOperation()), StringHelper.nonNullValue((Object)this.consumeDescriptor.getScheme()), StringHelper.nonNullValue((Object)this.consumeDescriptor.getHostname()), StringHelper.nonNullValue((Object)this.consumeDescriptor.getPort()), StringHelper.nonNullValue((Object)this.consumeDescriptor.getUsername()), StringHelper.nonNullValue((Object)this.consumeDescriptor.getFolder())));
                    this.externalListener.process(message);
                    message.setFlag(Flags.Flag.DELETED, true);
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, "Error when sending JBI request", t);
                    LoggingUtil.addMonitFailureTrace((Logger)this.logger, (FlowAttributes)PetalsExecutionContext.getFlowAttributes(), (String)t.getMessage(), (MessageExchange.Role)MessageExchange.Role.CONSUMER);
                }
            }
            this.mailSessionManager.closeFolderAndStore(folder, store, this.consumeDescriptor.isDelete());
        }
        catch (MessagingException e) {
            try {
                this.getLogger().log(Level.WARNING, e.getMessage(), e);
                this.mailSessionManager.closeFolderAndStore(folder, store, this.consumeDescriptor.isDelete());
                return;
            }
            catch (Throwable throwable) {
                this.mailSessionManager.closeFolderAndStore(folder, store, this.consumeDescriptor.isDelete());
                throw throwable;
            }
        }
    }
}

