/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail;

import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.ow2.petals.bc.mail.MailUtil;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.service.provide.ProvideDescriptor;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Node;

public class MimeMessageManager {
    protected Logger log;

    public MimeMessageManager(Logger log) {
        this.log = log;
    }

    public MimeMessage mapNormalizedMessageToMimeMessage(Session session, ProvideDescriptor provideDescriptor, Exchange exchange, Node rootNode) throws MessagingException, MissingElementException {
        this.log.finest("create email from JBI Exchange");
        MimeMessage mimeMessage = new MimeMessage(session);
        String sendMode = provideDescriptor.getSendMode();
        this.setMimeMessageAttributes(mimeMessage, provideDescriptor.getToAddress(), provideDescriptor.getFromAddress(), provideDescriptor.getSubject());
        MimeMultipart multipart = new MimeMultipart();
        if (!sendMode.equalsIgnoreCase("attachments-only")) {
            String content = MailUtil.extractMailBodyFromPayload(rootNode);
            try {
                this.setMimeMessageBody((Multipart)multipart, content, provideDescriptor.getContentType());
            }
            catch (javax.mail.MessagingException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        if (!sendMode.equalsIgnoreCase("content-only")) {
            this.setMimeMessageAttachments((Multipart)multipart, exchange, rootNode);
        }
        try {
            mimeMessage.setContent((Multipart)multipart);
        }
        catch (javax.mail.MessagingException e) {
            String msg = "Error setting Mime message contentwith all information collected from NormalizedMessage";
            throw new MessagingException("Error setting Mime message contentwith all information collected from NormalizedMessage", (Throwable)e);
        }
        return mimeMessage;
    }

    protected void setMimeMessageAttachments(Multipart multipart, Exchange exchange, Node rootNode) throws MessagingException {
        this.log.finest("set the email attachments");
        NormalizedMessage in = exchange.getInMessage();
        Set attachmentIds = in.getAttachmentNames();
        MimeBodyPart attachementBodyPart = null;
        DataHandler handler = null;
        if (attachmentIds != null) {
            for (String id : attachmentIds) {
                handler = in.getAttachment(id);
                this.log.finest("add " + id + " as MimeMessage attachment.");
                attachementBodyPart = new MimeBodyPart();
                try {
                    attachementBodyPart.setDataHandler(handler);
                    attachementBodyPart.setFileName(id);
                    multipart.addBodyPart((BodyPart)attachementBodyPart);
                }
                catch (javax.mail.MessagingException e) {
                    String msg = "Error setting MimeMessage attachments " + id;
                    this.log.warning(msg);
                }
            }
        }
    }

    protected void setMimeMessageAttributes(MimeMessage mimeMessage, String toAddress, String fromAddress, String subject) throws MessagingException {
        this.log.finest("set the email attributes");
        try {
            InternetAddress toInternetAddress = new InternetAddress(toAddress);
            InternetAddress fromInternetAddress = new InternetAddress(fromAddress);
            mimeMessage.setRecipient(Message.RecipientType.TO, (Address)toInternetAddress);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setFrom((Address)fromInternetAddress);
            mimeMessage.setSubject(subject);
        }
        catch (javax.mail.MessagingException e) {
            String msg = "Error setting MimeMessage attributes";
            throw new MessagingException("Error setting MimeMessage attributes", (Throwable)e);
        }
    }

    protected void setMimeMessageBody(Multipart multipart, String content, String contentType) throws javax.mail.MessagingException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)content, contentType);
        multipart.addBodyPart((BodyPart)messageBodyPart);
    }
}

