/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Timer;
import java.util.TimerTask;
import javax.jbi.messaging.MessagingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.bc.mail.MailComponent;
import org.ow2.petals.bc.mail.MailSessionManager;
import org.ow2.petals.bc.mail.MailUtil;
import org.ow2.petals.bc.mail.MimeMessageManager;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.service.consume.ConsumeDescriptor;
import org.ow2.petals.bc.mail.service.consume.ExternalEventPoller;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExternalListener
extends AbstractExternalListener {
    protected ConfigurationExtensions extensions;
    protected MailSessionManager mailSessionManager;
    protected MimeMessageManager mimeMessageManager;
    private Timer timer;

    public void init() {
        this.mailSessionManager = ((MailComponent)this.getComponent()).getMailSessionManager();
        this.mimeMessageManager = ((MailComponent)this.getComponent()).getMimeMessageManager();
    }

    public void process(Message message) throws MessagingException, PEtALSCDKException, IOException, javax.mail.MessagingException {
        this.getLogger().log(Level.INFO, "process an incoming email");
        Exchange exchange = this.createConsumeExchange(this.getConsumes(), Message.MEPConstants.IN_ONLY_PATTERN);
        this.setJBIContentAndAttachments((Part)message, exchange);
        this.setProperties(message, exchange);
        this.send(exchange);
    }

    protected void setJBIContentAndAttachments(Part message, Exchange exchange) throws IOException, javax.mail.MessagingException, MessagingException, PEtALSCDKException {
        Object content = message.getContent();
        if (content instanceof String) {
            if (exchange.getInMessageContentAsSource() == null) {
                if ("true".equals(this.getExtensions().get((Object)"isxmlcontent"))) {
                    this.getLogger().info("An XML part is set to JBI Exchange content");
                    exchange.setInMessageContent((Source)new StreamSource(new StringReader(content.toString())));
                } else {
                    this.getLogger().info("A text part is set to JBI Exchange content (wrap in <body> element)");
                    Document doc = DocumentBuilders.newDocument();
                    Element bodyElmt = doc.createElement("body");
                    bodyElmt.setTextContent(content.toString());
                    doc.appendChild(bodyElmt);
                    doc.normalize();
                    exchange.setInMessageContent(doc);
                }
            } else {
                this.getLogger().warning("a text part is found, but the JBI Exchange content has been already set");
            }
        } else if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.setJBIContentAndAttachments((Part)mp.getBodyPart(i), exchange);
            }
        } else if (content instanceof InputStream) {
            this.getLogger().info("add an attachment on JBI Exchange");
            exchange.addInMessageAttachment(message.getFileName(), message.getDataHandler());
        }
    }

    protected void setProperties(Message message, Exchange exchange) throws javax.mail.MessagingException {
        StringBuilder s_from = new StringBuilder();
        Address[] addresses = message.getFrom();
        if (addresses != null) {
            for (Address from : addresses) {
                s_from.append(from.toString()).append(";");
            }
            s_from.deleteCharAt(s_from.length() - 1);
        }
        StringBuilder s_reply = new StringBuilder();
        addresses = message.getReplyTo();
        if (addresses != null) {
            for (Address reply : addresses) {
                s_reply.append(reply.toString()).append(";");
            }
            if (s_reply.length() > 0) {
                s_reply.deleteCharAt(s_reply.length() - 1);
            }
        }
        if ((addresses = message.getAllRecipients()) != null) {
            StringBuilder s_to = new StringBuilder();
            for (Address to : addresses) {
                s_to.append(to.toString()).append(";");
            }
            if (s_to.length() > 0) {
                s_to = s_to.deleteCharAt(s_to.length() - 1);
            }
        }
        String s_subject = message.getSubject();
        this.getLogger().fine("set property " + Constants.FROM_QNAME + " : " + s_from);
        exchange.getInMessage().setProperty(Constants.FROM_QNAME.toString(), (Object)s_from);
        if (s_reply.length() > 0) {
            this.getLogger().fine("set property " + Constants.REPLY_TO_QNAME + " : " + s_reply);
            exchange.getInMessage().setProperty(Constants.REPLY_TO_QNAME.toString(), (Object)s_reply);
        }
        if (s_subject != null && s_subject.length() > 0) {
            this.getLogger().fine("set property " + Constants.ACTION_QNAME + " : " + s_subject);
            exchange.getInMessage().setProperty(Constants.ACTION_QNAME.toString(), (Object)s_subject);
        }
    }

    public void start() throws PEtALSCDKException {
        this.extensions = new ConfigurationExtensions(this.getConsumes().getAny());
        try {
            this.timer = new Timer();
            ConsumeDescriptor consumeDescriptor = MailUtil.buildConsumeDescriptor(this.extensions);
            ExternalEventPoller listener = new ExternalEventPoller(this.getLogger(), this, this.getConsumes(), consumeDescriptor, this.mailSessionManager);
            this.timer.schedule((TimerTask)listener, 0L, (long)Integer.parseInt(consumeDescriptor.getPeriod()));
        }
        catch (MissingElementException e) {
            this.getLogger().warning("Missing element in the jbi.xml : " + e.getElement());
        }
        catch (MessagingException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }

    public void stop() throws PEtALSCDKException {
        this.timer.cancel();
    }
}

