/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.ow2.petals.bc.mail.MailProvideExtFlowStepBeginLogData;
import org.ow2.petals.bc.mail.service.consume.ConsumeDescriptor;
import org.ow2.petals.bc.mail.service.provide.ProvideDescriptor;
import org.ow2.petals.commons.PetalsExecutionContext;

public class MailSessionManager {
    protected Logger log;

    public MailSessionManager(Logger log) {
        this.log = log;
    }

    public void closeFolderAndStore(Folder folder, Store store, boolean expunge) {
        block7: {
            block6: {
                try {
                    if (folder != null && folder.isOpen()) {
                        folder.close(expunge);
                    }
                }
                catch (Exception ex) {
                    if (folder == null) break block6;
                    this.log.log(Level.WARNING, "Error closing mail Folder :" + folder.toString(), ex);
                }
            }
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
            }
            catch (Exception ex) {
                if (store == null) break block7;
                this.log.log(Level.WARNING, "Error closing mail Store : " + store.toString(), ex);
            }
        }
    }

    public Session createSessionPropertiesFromDescriptor(ProvideDescriptor provideDescriptor) {
        Properties props = new Properties();
        if ("smtp".equals(provideDescriptor.getScheme())) {
            props.put("mail.transport.protocol", provideDescriptor.getScheme());
        } else {
            props.put("mail.store.protocol", provideDescriptor.getScheme());
        }
        props.put("mail.host", provideDescriptor.getHostname());
        if (provideDescriptor.getUsername() != null) {
            props.put("mail.user", provideDescriptor.getUsername());
        }
        if (provideDescriptor.getFromAddress() != null) {
            props.put("mail.from", provideDescriptor.getFromAddress());
        }
        if (provideDescriptor.getHeloHost() != null) {
            props.put("mail.smtp.localhost", provideDescriptor.getHeloHost());
        }
        return Session.getInstance((Properties)props);
    }

    public Session createSessionPropertiesFromDescriptor(ConsumeDescriptor consumeDescriptor) {
        Properties props = new Properties();
        props.put("mail.store.protocol", consumeDescriptor.getScheme());
        props.put("mail.host", consumeDescriptor.getHostname());
        if (consumeDescriptor.getUsername() != null) {
            props.put("mail.user", consumeDescriptor.getUsername());
        }
        return Session.getInstance((Properties)props);
    }

    public Folder getFolderAndOpen(Store store, ConsumeDescriptor consumeDescriptor) throws MessagingException {
        String msg = "";
        Folder folder = null;
        folder = store.getDefaultFolder();
        if (folder == null) {
            msg = "No default folder for this store : " + store.toString();
            throw new MessagingException(msg);
        }
        if ((folder = folder.getFolder(consumeDescriptor.getFolder())) == null) {
            msg = "Invalid folder : " + consumeDescriptor.getFolder();
            throw new MessagingException(msg);
        }
        folder.open(2);
        return folder;
    }

    public List<Message> getNewMails(Folder folder) throws MessagingException {
        Message[] lstMessage;
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Message message : lstMessage = folder.getMessages()) {
            if (message.isSet(Flags.Flag.DELETED)) continue;
            messages.add(message);
        }
        return messages;
    }

    public Store getStoreAndConnect(Session session, ConsumeDescriptor consumeDescriptor) throws MessagingException {
        Store store = null;
        store = session.getStore(consumeDescriptor.getScheme());
        store.connect(consumeDescriptor.getHostname(), Integer.parseInt(consumeDescriptor.getPort()), consumeDescriptor.getUsername(), consumeDescriptor.getPassword());
        return store;
    }

    public void sendMail(MimeMessage mimeMessage, ProvideDescriptor sessionDescriptor, Session session) throws MessagingException {
        Transport transport = session.getTransport("smtp");
        if (!StringHelper.isNullOrEmpty((String)sessionDescriptor.getUsername()) && !StringHelper.isNullOrEmpty((String)sessionDescriptor.getPassword())) {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), sessionDescriptor.getUsername(), sessionDescriptor.getPassword());
        } else if (!StringHelper.isNullOrEmpty((String)sessionDescriptor.getUsername())) {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), sessionDescriptor.getUsername(), null);
        } else {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), null, null);
        }
        mimeMessage.saveChanges();
        this.addMonitStepExtTrace(mimeMessage);
        transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        transport.close();
    }

    private void addMonitStepExtTrace(MimeMessage mimeMessage) throws MessagingException {
        String emailAddress = mimeMessage.getRecipients(MimeMessage.RecipientType.TO) != null && mimeMessage.getRecipients(MimeMessage.RecipientType.TO).length > 0 ? mimeMessage.getRecipients(MimeMessage.RecipientType.TO)[0].toString() : "";
        FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
        String flowInstanceId = "";
        String flowStepId = "";
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        this.log.log(Level.MONIT, "", (Object)new MailProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, emailAddress));
    }
}

