/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.internet.InternetAddress;
import org.ow2.petals.bc.mail.MailConstants;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.service.consume.ConsumeDescriptor;
import org.ow2.petals.bc.mail.service.provide.ProvideDescriptor;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MailUtil {
    public static ProvideDescriptor build(ConfigurationExtensions extensions) throws MessagingException, MissingElementException {
        ProvideDescriptor provideDescriptor = new ProvideDescriptor();
        provideDescriptor.setUsername(extensions.get((Object)"user"));
        provideDescriptor.setPassword(extensions.get((Object)"password"));
        provideDescriptor.setScheme(extensions.get((Object)"scheme"));
        provideDescriptor.setHostname(extensions.get((Object)"host"));
        provideDescriptor.setPort(extensions.get((Object)"port"));
        String host = null;
        host = extensions.get((Object)"helohost");
        if (host != null) {
            provideDescriptor.setHeloHost(host);
        }
        provideDescriptor.setFromAddress(extensions.get((Object)"from"));
        provideDescriptor.setReplyAddress(extensions.get((Object)"reply"));
        provideDescriptor.setToAddress(extensions.get((Object)"to"));
        provideDescriptor.setSubject(extensions.get((Object)"subject"));
        provideDescriptor.setSendMode(extensions.get((Object)"send-mode"));
        provideDescriptor.setContentType(extensions.get((Object)"content-type"));
        MailUtil.checkProperties(provideDescriptor);
        return provideDescriptor;
    }

    public static ConsumeDescriptor buildConsumeDescriptor(ConfigurationExtensions extensions) throws MessagingException, MissingElementException {
        ConsumeDescriptor sessionDescriptor = new ConsumeDescriptor();
        sessionDescriptor.setUsername(extensions.get((Object)"user", null));
        sessionDescriptor.setPassword(extensions.get((Object)"password", null));
        String scheme = extensions.get((Object)"scheme");
        sessionDescriptor.setScheme(scheme);
        sessionDescriptor.setHostname(extensions.get((Object)"host"));
        if ("pop3".equals(scheme)) {
            sessionDescriptor.setPort(extensions.get((Object)"port", "110"));
        } else if ("imap".equals(scheme)) {
            sessionDescriptor.setPort(extensions.get((Object)"port", "143"));
        }
        sessionDescriptor.setPeriod(extensions.get((Object)"period", "60000"));
        sessionDescriptor.setFolder(extensions.get((Object)"folder", "INBOX"));
        String s_expunge = extensions.get((Object)"delete");
        if (StringHelper.isNullOrEmpty((String)s_expunge)) {
            sessionDescriptor.setDelete(true);
        } else {
            sessionDescriptor.setDelete(Boolean.getBoolean(s_expunge));
        }
        MailUtil.checkProperties(sessionDescriptor);
        return sessionDescriptor;
    }

    public static ProvideDescriptor buildFromPayload(Node node) throws MissingElementException, MessagingException {
        Node heloHostNode;
        Node toNode;
        Node replyNode;
        Node pwdNode;
        Node schemeNode;
        ProvideDescriptor sessionDescriptor = new ProvideDescriptor();
        if (node == null || !node.getLocalName().equalsIgnoreCase("mail")) {
            throw new MissingElementException("mail");
        }
        Node hostNode = XMLHelper.findChild((Node)node, null, (String)"host", (boolean)false);
        if (hostNode != null) {
            sessionDescriptor.setHostname(hostNode.getTextContent());
        }
        if ((schemeNode = XMLHelper.findChild((Node)node, null, (String)"scheme", (boolean)false)) != null) {
            sessionDescriptor.setScheme(schemeNode.getTextContent());
        }
        sessionDescriptor.setScheme("smtp");
        Node portNode = XMLHelper.findChild((Node)node, null, (String)"port", (boolean)false);
        String port = null;
        if (portNode != null) {
            port = portNode.getTextContent();
        }
        sessionDescriptor.setPort(port);
        Node userNode = XMLHelper.findChild((Node)node, null, (String)"user", (boolean)false);
        if (userNode != null) {
            sessionDescriptor.setUsername(userNode.getTextContent());
        }
        if ((pwdNode = XMLHelper.findChild((Node)node, null, (String)"password", (boolean)false)) != null) {
            sessionDescriptor.setPassword(pwdNode.getTextContent());
        }
        Node sendModeNode = XMLHelper.findChild((Node)node, null, (String)"send-mode", (boolean)false);
        String sendMode = null;
        if (sendModeNode != null) {
            sendMode = sendModeNode.getTextContent();
        }
        sessionDescriptor.setSendMode(sendMode);
        Node fromNode = XMLHelper.findChild((Node)node, null, (String)"from", (boolean)false);
        if (fromNode != null) {
            sessionDescriptor.setFromAddress(fromNode.getTextContent());
        }
        if ((replyNode = XMLHelper.findChild((Node)node, null, (String)"reply", (boolean)false)) != null) {
            sessionDescriptor.setReplyAddress(replyNode.getTextContent());
        }
        if ((toNode = XMLHelper.findChild((Node)node, null, (String)"to", (boolean)false)) != null) {
            sessionDescriptor.setToAddress(toNode.getTextContent());
        }
        Node contentTypeNode = XMLHelper.findChild((Node)node, null, (String)"content-type", (boolean)false);
        String contenType = null;
        if (contentTypeNode != null) {
            contenType = contentTypeNode.getTextContent();
        }
        sessionDescriptor.setContentType(contenType);
        Node subjectNode = XMLHelper.findChild((Node)node, null, (String)"subject", (boolean)false);
        if (subjectNode != null) {
            sessionDescriptor.setSubject(subjectNode.getTextContent());
        }
        if ((heloHostNode = XMLHelper.findChild((Node)node, null, (String)"helohost", (boolean)false)) != null) {
            sessionDescriptor.setHeloHost(heloHostNode.getTextContent());
        }
        MailUtil.checkProperties(sessionDescriptor);
        return sessionDescriptor;
    }

    public static String extractMailBodyFromPayload(Node node) throws MissingElementException, MessagingException {
        Node bodyNode = XMLHelper.findChild((Node)node, null, (String)"body", (boolean)false);
        if (bodyNode == null) {
            throw new MissingElementException("body");
        }
        return XMLHelper.toString((NodeList)bodyNode.getChildNodes());
    }

    public static ProvideDescriptor buildFromProperties(Exchange exchange, Node node) throws MissingElementException, MessagingException {
        ProvideDescriptor sessionDescriptor = new ProvideDescriptor();
        NormalizedMessage inNormalizedMessage = exchange.getInMessage();
        if (node == null || !node.getLocalName().equalsIgnoreCase("mail")) {
            throw new MissingElementException("mail");
        }
        String host = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.HOST_QNAME.toString());
        sessionDescriptor.setHostname(host);
        String port = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.PORT_QNAME.toString());
        sessionDescriptor.setPort(port);
        String username = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.USER_QNAME.toString());
        sessionDescriptor.setUsername(username);
        String password = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.PASSWORD_QNAME.toString());
        sessionDescriptor.setPassword(password);
        String sendMode = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.SENDMODE_QNAME.toString());
        sessionDescriptor.setSendMode(sendMode);
        String scheme = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.SCHEME_QNAME.toString());
        sessionDescriptor.setScheme(scheme);
        String heloHost = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.HELOHOST_QNAME.toString());
        sessionDescriptor.setHeloHost(heloHost);
        String fromAddress = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.FROM_QNAME.toString());
        sessionDescriptor.setFromAddress(fromAddress);
        String toAddress = null;
        try {
            Object object;
            if (exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing") != null && (object = exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing")) instanceof Document) {
                toAddress = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType((Document)object).getAddress();
            }
        }
        catch (MessagingException e) {
        }
        catch (WSAddressingException e) {
            // empty catch block
        }
        if (StringHelper.isNullOrEmpty(toAddress)) {
            toAddress = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.TO_QNAME.toString());
        }
        sessionDescriptor.setToAddress(toAddress);
        String replyAddress = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.REPLY_TO_QNAME.toString());
        sessionDescriptor.setReplyAddress(replyAddress);
        String contentType = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.CONTENTTYPE_QNAME.toString());
        sessionDescriptor.setContentType(contentType);
        String subject = (String)inNormalizedMessage.getProperty(MailConstants.MailWSAddressing.ACTION_QNAME.toString());
        sessionDescriptor.setSubject(subject);
        MailUtil.checkProperties(sessionDescriptor);
        return sessionDescriptor;
    }

    public static boolean checkWsaProperties(Exchange exchange) {
        String fromAddress = (String)exchange.getInMessage().getProperty(MailConstants.MailWSAddressing.FROM_QNAME.toString());
        String toAddress = (String)exchange.getInMessage().getProperty(MailConstants.MailWSAddressing.TO_QNAME.toString());
        return !StringHelper.isNullOrEmpty((String)fromAddress) || !StringHelper.isNullOrEmpty((String)toAddress);
    }

    protected static void checkProperties(ProvideDescriptor provideDescriptor) throws MessagingException, MissingElementException {
        if (StringHelper.isNullOrEmpty((String)provideDescriptor.getHostname())) {
            throw new MissingElementException("host");
        }
        try {
            new InternetAddress(provideDescriptor.getFromAddress()).validate();
        }
        catch (Exception e) {
            throw new MissingElementException("from");
        }
        try {
            new InternetAddress(provideDescriptor.getToAddress()).validate();
        }
        catch (Exception e) {
            throw new MissingElementException("to");
        }
        if (!"smtp".equalsIgnoreCase(provideDescriptor.getScheme())) {
            String msg = "The specified scheme isn't supported : " + provideDescriptor.getScheme();
            throw new MessagingException(msg);
        }
    }

    protected static void checkProperties(ConsumeDescriptor consumeDescriptor) throws MessagingException, MissingElementException {
        if (StringHelper.isNullOrEmpty((String)consumeDescriptor.getHostname())) {
            throw new MissingElementException("host");
        }
        if (!"imap".equalsIgnoreCase(consumeDescriptor.getScheme()) && !"pop3".equalsIgnoreCase(consumeDescriptor.getScheme())) {
            throw new MessagingException("The specified scheme isn't supported : " + consumeDescriptor.getScheme());
        }
    }
}

