/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.listeners;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.petals.bc.mail.MailComponent;
import org.ow2.petals.bc.mail.MailSessionManager;
import org.ow2.petals.bc.mail.MimeMessageManager;
import org.ow2.petals.bc.mail.service.provide.AbstractSendService;
import org.ow2.petals.bc.mail.service.provide.NativeSendService;
import org.ow2.petals.bc.mail.service.provide.SuSendService;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.LoggingUtil;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;

public class JBIListener
extends AbstractJBIListener {
    protected MailSessionManager mailSessionManager;
    protected MimeMessageManager mimeMessageManager;
    protected NativeSendService sendMailService;

    private static final void validateExchange(Exchange exchange) throws MessagingException {
        QName operation = exchange.getOperation();
        if (operation == null) {
            throw new MessagingException("The JBI operation must be set by the consumer of the service.");
        }
        if (StringHelper.isNullOrEmpty((String)operation.getNamespaceURI())) {
            exchange.setOperation(new QName("http://petals.ow2.org/components/mail/version-3", operation.getLocalPart()));
        }
    }

    public void init() {
        this.mimeMessageManager = ((MailComponent)this.getComponent()).getMimeMessageManager();
        this.mailSessionManager = ((MailComponent)this.getComponent()).getMailSessionManager();
        this.sendMailService = new NativeSendService(this.mailSessionManager, this.mimeMessageManager, this.getLogger());
    }

    public boolean onJBIMessage(Exchange exchange) {
        if (exchange.isActiveStatus()) {
            AbstractSendService service = null;
            if (exchange.getFault() == null) {
                try {
                    if (!exchange.isInOnlyPattern()) {
                        throw new JBIException("Exchange pattern for the " + exchange.getOperation() + " operation must be " + Message.MEPConstants.IN_ONLY_PATTERN);
                    }
                    JBIListener.validateExchange(exchange);
                    service = this.component.getNativeWsdl() != null && WSDLUtilImpl.isDescriptionContaining((Description)this.component.getNativeWsdl().getDescription(), (ServiceEndpoint)exchange.getEndpoint()) ? new NativeSendService(this.mailSessionManager, this.mimeMessageManager, this.getLogger()) : new SuSendService(this.mailSessionManager, this.mimeMessageManager, this.getLogger(), this.getExtensions());
                    ((AbstractSendService)service).sendMail(exchange);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, e.getClass().getSimpleName() + " : " + e.getMessage());
                    exchange.setError(e);
                }
            }
        } else if (!ExchangeStatus.ACTIVE.equals(exchange.getStatus()) && exchange.isConsumerRole()) {
            LoggingUtil.addMonitEndOrFailureTrace((Logger)this.getLogger(), (Exchange)exchange, (FlowAttributes)exchange.getFlowAttributes());
        }
        return true;
    }
}

