/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.mail.service.provide;

import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.ow2.petals.bc.mail.MailSessionManager;
import org.ow2.petals.bc.mail.MailUtil;
import org.ow2.petals.bc.mail.MimeMessageManager;
import org.ow2.petals.bc.mail.MissingElementException;
import org.ow2.petals.bc.mail.service.provide.AbstractSendService;
import org.ow2.petals.bc.mail.service.provide.ProvideDescriptor;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Node;

public class NativeSendService
extends AbstractSendService {
    public NativeSendService(MailSessionManager mailSessionManager, MimeMessageManager mimeMessageManager, Logger logger) {
        super(mailSessionManager, mimeMessageManager, logger);
    }

    @Override
    public void sendMail(Exchange exchange) throws javax.jbi.messaging.MessagingException, MissingElementException {
        this.logger.info("JBI Exchange received - sendMail service requested");
        Node node = exchange.getInMessageContentAsDocument(false).getFirstChild();
        ProvideDescriptor provideDescriptor = MailUtil.checkWsaProperties(exchange) ? MailUtil.buildFromProperties(exchange, node) : MailUtil.buildFromPayload(node);
        Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(provideDescriptor);
        MimeMessage mimeMessage = this.mimeMessageManager.mapNormalizedMessageToMimeMessage(session, provideDescriptor, exchange, node);
        try {
            this.mailSessionManager.sendMail(mimeMessage, provideDescriptor, session);
        }
        catch (MessagingException e) {
            throw new javax.jbi.messaging.MessagingException((Throwable)e);
        }
        this.logger.info("email sent to " + provideDescriptor.getToAddress());
    }
}

