/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp.connection;

import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.transport.TransportProtocol;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.ow2.petals.bc.sftp.connection.SFTPConnectionInfo;
import org.ow2.petals.bc.sftp.connection.WrappedSftpClient;

public class WrappedSftpClientFactory
implements PoolableObjectFactory {
    private final SFTPConnectionInfo connectionConfiguration;
    private final Logger logger;

    public WrappedSftpClientFactory(SFTPConnectionInfo connectionConfiguration, Logger logger) {
        this.connectionConfiguration = connectionConfiguration;
        this.logger = logger;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void destroyObject(Object obj) throws Exception {
        WrappedSftpClient client = (WrappedSftpClient)((Object)obj);
        if (client != null) {
            SftpClient activeSftpClient = client.getActiveSftpClient();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Log out user and disconnect ssh session : [" + this.connectionConfiguration.toString() + "]");
            }
            if (activeSftpClient != null && !activeSftpClient.isClosed()) {
                activeSftpClient.quit();
            }
            if (client.isConnected()) {
                client.disconnect();
            }
            client = null;
        }
    }

    public Object makeObject() throws Exception {
        this.logger.finest("Create new instance of SFTPClient");
        WrappedSftpClient client = new WrappedSftpClient(this.connectionConfiguration, this.logger);
        client.addEventHandler(new EventHandler(client));
        client.connectAndLog();
        client.configure();
        return client;
    }

    public void passivateObject(Object obj) throws Exception {
    }

    public boolean validateObject(Object obj) {
        this.logger.finest("Validate instance of SFTPClient");
        WrappedSftpClient client = (WrappedSftpClient)((Object)obj);
        if (client == null) {
            return false;
        }
        try {
            SftpClient activeSftpClient = client.getActiveSftpClient();
            if (activeSftpClient != null && !activeSftpClient.isClosed() && client.isConnected()) {
                this.logger.finest("SFTPClient is connected");
                return true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private class EventHandler
    extends SshEventAdapter {
        final WrappedSftpClient client;

        public EventHandler(WrappedSftpClient client) {
            this.client = client;
        }

        public void onConnected(TransportProtocol arg0) {
        }

        public void onDisconnect(TransportProtocol arg0) {
        }

        public void onSocketTimeout(TransportProtocol arg0) {
            WrappedSftpClientFactory.this.logger.finest("Socket timeout occurs [" + arg0.getUnderlyingProviderDetail() + "]");
            try {
                WrappedSftpClientFactory.this.destroyObject((Object)this.client);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

