/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp.connection;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import org.ow2.petals.bc.sftp.ConfigurationException;
import org.ow2.petals.bc.sftp.authentication.SshAuthentication;

public class SFTPConnectionInfo {
    private final String directory;
    private int maxConnection;
    private long maxIdleTime;
    private final boolean overwrite;
    private final int port;
    private final String server;
    private final SshAuthentication sshAuthentication;

    public SFTPConnectionInfo(String server, String port, SshAuthentication sshAuthentication, String directory, boolean overwrite) throws ConfigurationException {
        this.server = server;
        try {
            this.port = !StringHelper.isNullOrEmpty((String)port) ? Integer.parseInt(port) : 22;
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("The port must be a number.");
        }
        this.sshAuthentication = sshAuthentication;
        this.directory = directory;
        this.overwrite = overwrite;
        this.validate();
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getKey() {
        return this.server + this.port + this.sshAuthentication.getKey() + this.directory;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getServer() {
        return this.server;
    }

    public final SshAuthentication getSshAuthentication() {
        return this.sshAuthentication;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public final String toString() {
        return "SFTP Connection Info : server=" + this.server + "; port=" + this.port + "; user=" + this.getSshAuthentication().getUser() + "; directory=" + this.directory;
    }

    protected boolean isOverwrite() {
        return this.overwrite;
    }

    private final void validate() throws ConfigurationException {
        if (StringHelper.isNullOrEmpty((String)this.server)) {
            throw new ConfigurationException("Missing configuration element : server");
        }
        if (this.port < 0) {
            throw new ConfigurationException("The specified port is not valid. Port value range is 0-65535");
        }
        if (this.sshAuthentication == null) {
            throw new ConfigurationException("Missing configuration element : SSH Authentication");
        }
    }
}

