/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp.authentication;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import org.ow2.petals.bc.sftp.ConfigurationException;
import org.ow2.petals.bc.sftp.authentication.SshAuthentication;

public final class SshPasswordAuthentication
extends SshAuthentication {
    private final String password;

    public SshPasswordAuthentication(String user, String password) throws ConfigurationException {
        super(user);
        this.password = password;
        this.validate();
    }

    public final String getPassword() {
        return this.password;
    }

    @Override
    public final SshAuthenticationClient getAuthenticationClient() {
        PasswordAuthenticationClient client = new PasswordAuthenticationClient();
        client.setUsername(this.getUser());
        client.setPassword(this.password);
        return client;
    }

    @Override
    public final String getKey() {
        return this.getUser() + this.password;
    }

    @Override
    public final String toString() {
        return super.toString() + "password=" + this.password + ")";
    }

    private final void validate() throws ConfigurationException {
        if (StringHelper.isNullOrEmpty((String)this.password)) {
            throw new ConfigurationException("Missing configuration element : password");
        }
    }
}

