/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.util.Arrays;
import java.util.List;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SFTPUtil {
    private static final String FILENAME = "filename";
    private static final String IO_FAULT = "ioFault";
    private static final String CONFIGURATION_FAULT = "configurationFault";

    public static String generateFileNameList(List<String> names, QName operation) {
        StringBuffer result = new StringBuffer();
        result.append("<tns:" + operation.getLocalPart() + "Response xmlns:tns='");
        result.append(operation.getNamespaceURI());
        result.append("'>");
        for (String string : names) {
            result.append("<tns:filename>");
            result.append(string);
            result.append("</tns:filename>");
        }
        result.append("</tns:" + operation.getLocalPart() + "Response>");
        return result.toString();
    }

    public static Document generateMTOMListResponse(List<String> names, QName operation) {
        Document doc = DocumentBuilders.newDocument();
        Element root = doc.createElementNS(operation.getNamespaceURI(), "tns:" + operation.getLocalPart() + "Response");
        root.appendChild(MtomUtil.generateMtomStructure((Document)doc, names, (QName)new QName(operation.getNamespaceURI(), "attachments", "tns"), (QName)new QName(operation.getNamespaceURI(), FILENAME, "tns")));
        doc.appendChild(root);
        return doc;
    }

    public static Document generateMTOMResponse(String names, QName operation) {
        Document doc = DocumentBuilders.newDocument();
        Element root = doc.createElementNS(operation.getNamespaceURI(), "tns:" + operation.getLocalPart() + "Response");
        root.appendChild(MtomUtil.generateMtomStructure((Document)doc, Arrays.asList(names), (QName)new QName(operation.getNamespaceURI(), "attachment", "tns"), (QName)new QName(operation.getNamespaceURI(), FILENAME, "tns")));
        doc.appendChild(root);
        return doc;
    }

    public static void setIOFaultOnExchange(Exchange exchange, String ioMessage) throws MessagingException {
        StringBuffer faultMessage = new StringBuffer();
        faultMessage.append("<tns:ioFault xmlns:tns='");
        faultMessage.append(exchange.getOperation().getNamespaceURI());
        faultMessage.append("'><tns:message>");
        faultMessage.append(ioMessage);
        faultMessage.append("</tns:message></tns:ioFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(SourceUtil.createSource((String)faultMessage.toString()));
            exchange.setFault(fault);
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    public static void setConfigurationFaultOnExchange(Exchange exchange, String configurationError) throws MessagingException {
        StringBuffer faultMessage = new StringBuffer();
        faultMessage.append("<tns:configurationFault xmlns:tns='");
        faultMessage.append(exchange.getOperation().getNamespaceURI());
        faultMessage.append("'><tns:element>");
        faultMessage.append(configurationError);
        faultMessage.append("</tns:element></tns:configurationFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(SourceUtil.createSource((String)faultMessage.toString()));
            exchange.setFault(fault);
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    public static final boolean checkMEP(Exchange exchange, boolean isInOnly, boolean isRobustInOnly, boolean isInOptionalOut, boolean isInOut) {
        if (isInOnly && exchange.isInOnlyPattern()) {
            return true;
        }
        if (isRobustInOnly && exchange.isRobustInOnlyPattern()) {
            return true;
        }
        if (isInOptionalOut && exchange.isInOptionalOutPattern()) {
            return true;
        }
        return isInOnly && exchange.isInOutPattern();
    }

    public static final void addRootElement(Document document, QName rootElement) {
        Element rootElt = document.createElementNS(rootElement.getNamespaceURI(), rootElement.getLocalPart());
        rootElt.appendChild(document.getDocumentElement());
        document.appendChild(rootElt);
    }

    public static String getValidMepMessageForOperation(String operation, Message.MEPConstants ... mep) {
        StringBuilder builder = new StringBuilder();
        builder.append("Exchange pattern for the " + operation.toUpperCase() + " operation must be ");
        for (int i = 0; i < mep.length; ++i) {
            if (i > 0) {
                builder.append(" or ");
            }
            builder.append(mep[i]);
        }
        return builder.toString();
    }
}

