/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.bc.sftp.ConfigurationException;
import org.ow2.petals.bc.sftp.SFTPComponent;
import org.ow2.petals.bc.sftp.connection.SFTPConnectionInfo;
import org.ow2.petals.bc.sftp.connection.SFTPConnectionInfoBuilder;
import org.ow2.petals.bc.sftp.connection.WrappedSftpClientFactory;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class SFtpSuManager
extends AbstractServiceUnitManager {
    private final Logger logger;

    public SFtpSuManager(AbstractComponent component, Logger logger) {
        super(component);
        this.logger = logger;
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        SFTPConnectionInfo connectionConfiguration;
        ServiceUnitDataHandler handler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
        Provides provides = (Provides)handler.getDescriptor().getServices().getProvides().get(0);
        ConfigurationExtensions extensions = handler.getConfigurationExtensions((Object)provides);
        try {
            connectionConfiguration = SFTPConnectionInfoBuilder.buildSFTPConnectionInfo(extensions, provides.getRetrypolicy());
        }
        catch (ConfigurationException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        WrappedSftpClientFactory factory = new WrappedSftpClientFactory(connectionConfiguration, this.logger);
        GenericObjectPool pool = new GenericObjectPool((PoolableObjectFactory)factory);
        pool.setConfig(this.configurePool(connectionConfiguration, pool));
        ((SFTPComponent)this.component).getMapOfPool().put(provides, pool);
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        ServiceUnitDataHandler handler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
        Provides provides = (Provides)handler.getDescriptor().getServices().getProvides().get(0);
        ObjectPool pool = (ObjectPool)((SFTPComponent)this.component).getMapOfPool().get(provides);
        try {
            if (pool != null) {
                this.logger.finest("Closing pool's resource");
                pool.clear();
                pool.close();
            }
        }
        catch (Exception e) {
            this.logger.finest("Exception when closing pool's resource: " + e.getMessage());
        }
    }

    private final GenericObjectPool.Config configurePool(SFTPConnectionInfo connectionConfiguration, GenericObjectPool pool) {
        GenericObjectPool.Config conf = new GenericObjectPool.Config();
        int maxConnection = connectionConfiguration.getMaxConnection();
        if (maxConnection <= 0) {
            conf.whenExhaustedAction = (byte)2;
        } else {
            conf.whenExhaustedAction = 1;
            conf.maxWait = -1L;
            conf.maxActive = maxConnection;
            conf.maxIdle = maxConnection;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Number of maximum connection for the pool: " + maxConnection);
        }
        conf.testOnBorrow = true;
        conf.testOnReturn = true;
        return conf;
    }
}

