/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp.connection;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.IgnoreHostKeyVerification;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.util.ByteArrayDataSource;
import org.ow2.petals.bc.sftp.connection.SFTPConnectionInfo;
import org.ow2.petals.component.framework.util.FileNamePatternUtil;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WrappedSftpClient
extends SshClient {
    private SftpClient client;
    private final SFTPConnectionInfo info;
    private final Logger logger;

    public WrappedSftpClient(SFTPConnectionInfo connectionConfiguration, Logger logger) {
        this.logger = logger;
        this.info = connectionConfiguration;
    }

    public void configure() throws IOException {
        if (!StringHelper.isNullOrEmpty((String)this.info.getDirectory())) {
            this.client.cd(this.info.getDirectory());
        }
    }

    public void connectAndLog() throws IOException {
        this.setSocketTimeout((int)this.info.getMaxIdleTime());
        try {
            this.connect(this.info.getServer(), this.info.getPort(), (HostKeyVerification)new IgnoreHostKeyVerification());
        }
        catch (IOException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't open a connection to [");
            errorSB.append(this.info);
            errorSB.append("]. Cause : " + ex.getMessage());
            throw new IOException(errorSB.toString(), ex);
        }
        SshAuthenticationClient sshAuthenticationClient = this.info.getSshAuthentication().getAuthenticationClient();
        int authenticationResult = this.authenticate(sshAuthenticationClient);
        if (authenticationResult != 4) {
            this.disconnect();
            throw new IOException("Can't open a connection to [" + this.info + "]. Cause : Authentication failed");
        }
        this.client = this.openSftpClient();
    }

    public void del(String filePattern) throws IOException {
        FileNamePatternUtil.RegexFileNameFilter filter = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(filePattern);
        List fileContainedWithinWorkingDir = this.client.ls();
        for (SftpFile file : fileContainedWithinWorkingDir) {
            if (!file.isFile() || !file.canRead() || !filter.accept(null, file.getFilename())) continue;
            file.delete();
            break;
        }
    }

    public Document get(String filePattern) throws IOException {
        FileNamePatternUtil.RegexFileNameFilter filter = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(filePattern);
        Document result = null;
        List fileContainedWithinWorkingDir = this.client.ls();
        for (SftpFile file : fileContainedWithinWorkingDir) {
            if (!file.isFile() || !file.canRead() || !filter.accept(null, file.getFilename())) continue;
            result = this.getAsDocument(file, this.client);
            break;
        }
        if (result == null) {
            throw new IOException("Can not find the specified resource");
        }
        return result;
    }

    public DataHandler getAsAttachment(String filePattern) throws IOException {
        FileNamePatternUtil.RegexFileNameFilter filter = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(filePattern);
        DataHandler retrievedFile = null;
        List fileContainedWithinWorkingDir = this.client.ls();
        for (SftpFile file : fileContainedWithinWorkingDir) {
            if (!file.isFile() || !file.canRead() || !filter.accept(null, file.getFilename())) continue;
            retrievedFile = this.getAsDataHandler(file, this.client);
            break;
        }
        if (retrievedFile == null) {
            throw new IOException("File not found");
        }
        return retrievedFile;
    }

    public SFTPConnectionInfo getInfo() {
        return this.info;
    }

    public List<String> list() throws IOException {
        ArrayList<String> fileList = new ArrayList<String>();
        List sftpFiles = this.client.ls();
        for (SftpFile file : sftpFiles) {
            if (!file.isFile()) continue;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("file : " + file.getFilename());
            }
            fileList.add(file.getFilename());
        }
        return fileList;
    }

    public Map<String, DataHandler> mGet(List<String> fileFilterList) throws IOException {
        HashMap<String, DataHandler> dataHandlers = new HashMap<String, DataHandler>();
        LinkedList<FileNamePatternUtil.RegexFileNameFilter> filterList = new LinkedList<FileNamePatternUtil.RegexFileNameFilter>();
        for (String string : fileFilterList) {
            filterList.add(FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(string));
        }
        FileNamePatternUtil.RegexFileNameFilter filter = FileNamePatternUtil.getInstance().buildFileNameFilterFromFilters(filterList);
        List filesContainedWithinWorkingDir = this.client.ls();
        for (SftpFile file : filesContainedWithinWorkingDir) {
            if (!file.isFile() || !file.canRead() || !filter.accept(null, file.getFilename())) continue;
            dataHandlers.put(file.getFilename(), this.getAsDataHandler(file, this.client));
        }
        return dataHandlers;
    }

    public boolean mput(Map<String, DataHandler> attachments) throws IOException {
        boolean result = false;
        for (Map.Entry<String, DataHandler> attachmentEntry : attachments.entrySet()) {
            String fileName = attachmentEntry.getKey();
            this.logger.finest("Start sending : " + fileName + " file on the SFTP server.");
            boolean fileExist = true;
            try {
                this.client.stat(fileName);
            }
            catch (IOException e) {
                fileExist = false;
            }
            if (this.info.isOverwrite() || !fileExist) {
                InputStream stream = attachments.get(fileName).getInputStream();
                this.client.put(stream, fileName);
                FileAttributes transmittedFileAttributes = this.client.stat(fileName);
                result = transmittedFileAttributes.isFile();
                if (!result) {
                    throw new IOException("Problem while sending " + fileName + " on the SFTP server.");
                }
                this.logger.finest(fileName + " sent on the SFTP server");
                continue;
            }
            throw new IOException("File [" + fileName + "] already exists.");
        }
        return result;
    }

    public boolean putString(String fileName, String content) throws IOException {
        boolean result = false;
        boolean fileExist = true;
        try {
            this.client.stat(fileName);
        }
        catch (IOException e) {
            fileExist = false;
        }
        if (this.info.isOverwrite() || !fileExist) {
            this.logger.finest("Start sending :" + fileName + " file on the SFTP server");
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
            this.client.put((InputStream)stream, fileName);
            FileAttributes transmittedFileAttributes = this.client.stat(fileName);
            result = transmittedFileAttributes.isFile();
            if (!result) {
                throw new IOException("Problem while sending " + fileName + " on the SFTP server.");
            }
        } else {
            throw new IOException("File [" + fileName + "] already exists.");
        }
        this.logger.finest(fileName + " sent on the FTP server");
        return result;
    }

    private DataHandler getAsDataHandler(SftpFile remoteFile, SftpClient client) throws IOException {
        this.logger.info("start receiving file " + remoteFile.getFilename() + " from SFTP server");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(remoteFile.getAttributes().getSize().intValue());
        client.get(remoteFile.getFilename(), (OutputStream)outputStream);
        outputStream.flush();
        this.logger.finest(remoteFile.getFilename() + " file received from SFTP server");
        ByteArrayDataSource datasource = new ByteArrayDataSource(outputStream.toByteArray(), FileTypeMap.getDefaultFileTypeMap().getContentType(remoteFile.getFilename()));
        outputStream.close();
        datasource.setName(remoteFile.getFilename());
        DataHandler result = new DataHandler((DataSource)datasource);
        this.logger.finest(remoteFile.getFilename() + " set as DataHandler");
        return result;
    }

    private Document getAsDocument(SftpFile remoteFile, SftpClient client) throws IOException {
        Document doc;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("start receiving file " + remoteFile.getFilename() + " from FTP server");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        client.get(remoteFile.getFilename(), (OutputStream)out);
        out.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        out.close();
        try {
            doc = XMLUtil.loadDocument((InputStream)in);
        }
        catch (SAXException e) {
            throw new IOException("processed file [" + remoteFile.getFilename() + "] is not a valid xml file : " + e.getMessage());
        }
        finally {
            in.close();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(remoteFile.getFilename() + " file received from FTP server and set as document");
        }
        return doc;
    }
}

