/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp.service;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.bc.sftp.ConfigurationException;
import org.ow2.petals.bc.sftp.SFTPUtil;
import org.ow2.petals.bc.sftp.SftpProvideExtFlowStepBeginLogData;
import org.ow2.petals.bc.sftp.connection.WrappedSftpClient;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.logger.ProvideExtFlowStepEndLogData;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SFTPService {
    private final Logger logger;

    public SFTPService(Logger logger) {
        this.logger = logger;
    }

    public void processDIR(Exchange exchange, Document inDocument, WrappedSftpClient client) throws MessagingException {
        this.logger.info("JBI exchange receive - Process DIR operation");
        if (!exchange.isInOutPattern()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append(SFTPUtil.getValidMepMessageForOperation("dir", Message.MEPConstants.IN_OUT_PATTERN));
            throw new MessagingException(errorSB.toString());
        }
        if (!exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("No attachement expected.");
            throw new MessagingException(errorSB.toString());
        }
        Element root = inDocument.getDocumentElement();
        if (root == null || !"dir".equalsIgnoreCase(root.getLocalName())) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Invalid message content for the DIR operation.");
            throw new MessagingException(errorSB.toString());
        }
        List<String> fileNames = null;
        try {
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = null;
            String flowStepId = null;
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            SftpProvideExtFlowStepBeginLogData sftpProvideExtFlowStepBeginLogData = new SftpProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, client.getInfo().getDirectory());
            this.logger.log(Level.MONIT, "", (Object)sftpProvideExtFlowStepBeginLogData);
            fileNames = client.list();
            ProvideExtFlowStepEndLogData sftpProvideExtFlowStepEndLogData = new ProvideExtFlowStepEndLogData(flowInstanceId, flowStepId);
            this.logger.log(Level.MONIT, "", sftpProvideExtFlowStepEndLogData);
            String result = SFTPUtil.generateFileNameList(fileNames, exchange.getOperation());
            exchange.getOutMessage().setContent(SourceUtil.createSource((String)result));
        }
        catch (NullPointerException ex) {
            String error = "Can not retrieve file list from the SFTP server [" + client.getInfo() + "]. Cause : Socket timeout occurs";
            throw new MessagingException(error);
        }
        catch (IOException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not retrieve file list from the SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. IOException : ");
            errorSB.append(ex.getMessage());
            SFTPUtil.setIOFaultOnExchange(exchange, errorSB.toString());
        }
        catch (PEtALSCDKException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not retrieve file list from the SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. PetalsCDKException : ");
            errorSB.append(ex.getMessage());
            SFTPUtil.setIOFaultOnExchange(exchange, errorSB.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("DIR operation ended");
        }
    }

    public void processPUT(Exchange exchange, Document inDocument, WrappedSftpClient client) throws MessagingException {
        this.logger.info("JBI exchange receive - Process PUT operation");
        if (!exchange.isInOnlyPattern()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append(SFTPUtil.getValidMepMessageForOperation("put", Message.MEPConstants.IN_ONLY_PATTERN));
            throw new MessagingException(errorSB.toString());
        }
        if (!exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("No attachement expected.");
            throw new MessagingException(errorSB.toString());
        }
        Node root = inDocument.getFirstChild();
        if (root == null || !"put".equalsIgnoreCase(root.getLocalName())) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Invalid message content for the PUT operation");
            throw new MessagingException(errorSB.toString());
        }
        ArrayList<String> filenames = new ArrayList<String>();
        NodeList rootChildNodes = root.getChildNodes();
        for (int i = 0; i < rootChildNodes.getLength(); ++i) {
            Node node = rootChildNodes.item(i);
            if (node == null || !"filename".equalsIgnoreCase(node.getLocalName())) continue;
            filenames.add(node.getTextContent());
        }
        if (filenames.isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't retrieve the filename from the XML content : ");
            errorSB.append("No filename node found.");
            throw new MessagingException(errorSB.toString());
        }
        if (filenames.size() > 1) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't retrieve the filename from the XML content : ");
            errorSB.append("Too many filenames nodes found.");
            throw new MessagingException(errorSB.toString());
        }
        String fileName = (String)filenames.get(0);
        if (StringHelper.isNullOrEmpty((String)fileName)) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't retrieve the filename from the XML content : ");
            errorSB.append("missing filename.");
            throw new MessagingException(errorSB.toString());
        }
        Node bodyNode = XMLHelper.findChild((Node)root, null, (String)"body", (boolean)false);
        if (bodyNode == null || !"body".equalsIgnoreCase(bodyNode.getLocalName())) {
            this.logger.warning("Can't retrieve message body.");
        }
        try {
            String content = XMLHelper.toString((NodeList)bodyNode.getChildNodes());
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = null;
            String flowStepId = null;
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            SftpProvideExtFlowStepBeginLogData sftpProvideExtFlowStepBeginLogData = new SftpProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, fileName, client.getInfo().getDirectory());
            this.logger.log(Level.MONIT, "", (Object)sftpProvideExtFlowStepBeginLogData);
            client.putString(fileName, content);
        }
        catch (IOException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put XML content on SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. IOException : ");
            errorSB.append(ex.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        catch (NullPointerException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put XML content on SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. Cause : Socket timeout occurs");
            throw new MessagingException(errorSB.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("PUT operation ended");
        }
    }

    public void processMPUT(Exchange exchange, Document inDocument, WrappedSftpClient client) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process MPUT operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(SFTPUtil.getValidMepMessageForOperation("mput", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        if (exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("One or more attachments expected.");
            throw new MessagingException(errorSB.toString());
        }
        try {
            MtomUtil.MtomMapping mapping = MtomUtil.getMtomMapping((Exchange)exchange, (Element)inDocument.getDocumentElement());
            Map attachments = mapping.getContentIdToDataHandler();
            StringBuffer filePattern = new StringBuffer("(");
            int fileNamesLength = attachments.size();
            Iterator attachmentsKeyIterator = attachments.keySet().iterator();
            int i = 0;
            while (attachmentsKeyIterator.hasNext()) {
                filePattern.append((String)attachmentsKeyIterator.next());
                if (i < fileNamesLength - 1) {
                    filePattern.append("|");
                }
                ++i;
            }
            filePattern.append(")");
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = null;
            String flowStepId = null;
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            SftpProvideExtFlowStepBeginLogData sftpProvideExtFlowStepBeginLogData = new SftpProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, filePattern.toString(), client.getInfo().getDirectory());
            this.logger.log(Level.MONIT, "", (Object)sftpProvideExtFlowStepBeginLogData);
            client.mput(attachments);
        }
        catch (NullPointerException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put file on SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. Cause : Socket timeout occurs");
            throw new MessagingException(errorSB.toString());
        }
        catch (IOException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put file on SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. IOException : ");
            errorSB.append(ex.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("MPUT operation ended");
        }
    }

    public void processGET(Exchange exchange, Document inDocument, WrappedSftpClient client) throws MessagingException, ConfigurationException {
        this.logger.info("JBI exchange receive - Process GET operation");
        if (!exchange.isInOutPattern()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append(SFTPUtil.getValidMepMessageForOperation("get", Message.MEPConstants.IN_OUT_PATTERN));
            throw new MessagingException(errorSB.toString());
        }
        if (!exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("No attachement expected.");
            throw new MessagingException(errorSB.toString());
        }
        Node root = inDocument.getFirstChild();
        if (root == null || !"get".equalsIgnoreCase(root.getLocalName())) {
            throw new ConfigurationException("Missing root element : get");
        }
        Node filePatternNode = XMLHelper.findChild((Node)root, null, (String)"filename", (boolean)true);
        String filePattern = null;
        if (filePatternNode != null) {
            filePattern = filePatternNode.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(filePattern)) {
            throw new ConfigurationException("Missing request element :filename");
        }
        try {
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = null;
            String flowStepId = null;
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            SftpProvideExtFlowStepBeginLogData sftpProvideExtFlowStepBeginLogData = new SftpProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, filePattern, client.getInfo().getDirectory());
            this.logger.log(Level.MONIT, "", (Object)sftpProvideExtFlowStepBeginLogData);
            Document result = client.get(filePattern);
            ProvideExtFlowStepEndLogData sftpProvideExtFlowStepEndLogData = new ProvideExtFlowStepEndLogData(flowInstanceId, flowStepId);
            this.logger.log(Level.MONIT, "", sftpProvideExtFlowStepEndLogData);
            SFTPUtil.addRootElement(result, new QName(exchange.getOperation().getNamespaceURI(), "ver:getResponse"));
            exchange.setOutMessageContent(result);
        }
        catch (NullPointerException ex) {
            String error = "Can not get file [" + filePattern + "] on SFTP server [" + client.getInfo().getServer() + "]. Cause : Socket timeout occurs";
            throw new MessagingException(error);
        }
        catch (IOException ex) {
            SFTPUtil.setIOFaultOnExchange(exchange, "Can not get file [" + filePattern + "] on SFTP server [" + client.getInfo().getServer() + "]. Cause : " + ex.getMessage());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("GET operation ended");
        }
    }

    public void processGetAsAttachment(Exchange exchange, Document inDocument, WrappedSftpClient client) throws MessagingException, ConfigurationException {
        this.logger.info("JBI exchange receive - Process GET operation");
        if (!exchange.isInOutPattern()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append(SFTPUtil.getValidMepMessageForOperation("getAsAttachment", Message.MEPConstants.IN_OUT_PATTERN));
            throw new MessagingException(errorSB.toString());
        }
        if (!exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("No attachement expected.");
            throw new MessagingException(errorSB.toString());
        }
        Node root = inDocument.getFirstChild();
        if (root == null || !"getAsAttachment".equalsIgnoreCase(root.getLocalName())) {
            throw new ConfigurationException("Missing root element : getAsAttachment");
        }
        Node filePatternNode = XMLHelper.findChild((Node)root, null, (String)"filename", (boolean)true);
        String filePattern = null;
        if (filePatternNode != null) {
            filePattern = filePatternNode.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(filePattern)) {
            throw new ConfigurationException("Missing request element : filename");
        }
        try {
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = null;
            String flowStepId = null;
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            SftpProvideExtFlowStepBeginLogData sftpProvideExtFlowStepBeginLogData = new SftpProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, filePattern, client.getInfo().getDirectory());
            this.logger.log(Level.MONIT, "", (Object)sftpProvideExtFlowStepBeginLogData);
            DataHandler retrievedFile = client.getAsAttachment(filePattern);
            ProvideExtFlowStepEndLogData sftpProvideExtFlowStepEndLogData = new ProvideExtFlowStepEndLogData(flowInstanceId, flowStepId);
            this.logger.log(Level.MONIT, "", sftpProvideExtFlowStepEndLogData);
            Document response = SFTPUtil.generateMTOMResponse(retrievedFile.getName(), exchange.getOperation());
            exchange.setOutMessageAttachment(retrievedFile.getName(), retrievedFile);
            exchange.setOutMessageContent(response);
        }
        catch (NullPointerException ex) {
            String error = "Can not get file [" + filePattern + "] on SFTP server [" + client.getInfo().getServer() + "]. Cause : Socket timeout occurs";
            throw new MessagingException(error);
        }
        catch (IOException ex) {
            SFTPUtil.setIOFaultOnExchange(exchange, "Can not get file [" + filePattern + "] on SFTP server [" + client.getInfo().getServer() + "]. Cause : " + ex.getMessage());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("GET operation ended");
        }
    }

    public void processMGET(Exchange exchange, Document inDocument, WrappedSftpClient client) throws MessagingException, ConfigurationException {
        StringBuilder errorSB;
        this.logger.info("JBI exchange receive - Process MGET operation");
        if (!exchange.isInOutPattern()) {
            StringBuilder errorSB2 = new StringBuilder();
            errorSB2.append(SFTPUtil.getValidMepMessageForOperation("mget", Message.MEPConstants.IN_OUT_PATTERN));
            throw new MessagingException(errorSB2.toString());
        }
        if (!exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB3 = new StringBuilder();
            errorSB3.append("No attachement expected.");
            throw new MessagingException(errorSB3.toString());
        }
        Node root = inDocument.getFirstChild();
        if (root == null || !"mget".equalsIgnoreCase(root.getLocalName())) {
            throw new ConfigurationException("Missing root element : mget");
        }
        NodeList list = root.getChildNodes();
        LinkedList<String> fileNames = new LinkedList<String>();
        for (int index = 0; index < list.getLength(); ++index) {
            Node node = list.item(index);
            if (!"filename".equalsIgnoreCase(node.getLocalName())) continue;
            String fileName = node.getTextContent();
            fileNames.add(fileName);
        }
        if (fileNames.isEmpty()) {
            throw new ConfigurationException("Missing request element : filename");
        }
        try {
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = null;
            String flowStepId = null;
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            StringBuffer filePattern = new StringBuffer("(");
            int fileNamesLength = fileNames.size();
            for (int i = 0; i < fileNamesLength; ++i) {
                filePattern.append((String)fileNames.get(i));
                if (i >= fileNamesLength - 1) continue;
                filePattern.append("|");
            }
            filePattern.append(")");
            SftpProvideExtFlowStepBeginLogData sftpProvideExtFlowStepBeginLogData = new SftpProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, filePattern.toString(), client.getInfo().getDirectory());
            this.logger.log(Level.MONIT, "", (Object)sftpProvideExtFlowStepBeginLogData);
            Map<String, DataHandler> files = client.mGet(fileNames);
            ProvideExtFlowStepEndLogData sftpProvideExtFlowStepEndLogData = new ProvideExtFlowStepEndLogData(flowInstanceId, flowStepId);
            this.logger.log(Level.MONIT, "", sftpProvideExtFlowStepEndLogData);
            for (Map.Entry<String, DataHandler> filesEntry : files.entrySet()) {
                exchange.getOutMessage().addAttachment(filesEntry.getKey(), filesEntry.getValue());
            }
            LinkedList<String> retrievedFilenames = new LinkedList<String>(files.keySet());
            Document outDoc = SFTPUtil.generateMTOMListResponse(retrievedFilenames, exchange.getOperation());
            exchange.setOutMessageContent(outDoc);
        }
        catch (NullPointerException ex) {
            errorSB = new StringBuilder();
            errorSB.append("Can not get files on SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. Cause : Socket timeout occurs");
            throw new MessagingException(errorSB.toString());
        }
        catch (IOException ex) {
            errorSB = new StringBuilder();
            errorSB.append("Can not get file on SFTP server [");
            errorSB.append(client.getInfo());
            errorSB.append("]. IOException : ");
            errorSB.append(ex.getMessage());
            SFTPUtil.setIOFaultOnExchange(exchange, errorSB.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("MGET operation ended");
        }
    }

    public void processDel(Exchange exchange, Document inDocument, WrappedSftpClient client) throws MessagingException, ConfigurationException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process DEL operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(SFTPUtil.getValidMepMessageForOperation("del", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        Node root = inDocument.getFirstChild();
        if (root == null || !"del".equalsIgnoreCase(root.getLocalName())) {
            throw new ConfigurationException("Missing root element : del");
        }
        Node filePatternNode = XMLHelper.findChild((Node)root, null, (String)"filename", (boolean)true);
        String filePattern = null;
        if (filePatternNode == null) {
            throw new ConfigurationException("Missing element : filename");
        }
        filePattern = filePatternNode.getTextContent();
        try {
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = null;
            String flowStepId = null;
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            SftpProvideExtFlowStepBeginLogData sftpProvideExtFlowStepBeginLogData = new SftpProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, filePattern, client.getInfo().getDirectory());
            this.logger.log(Level.MONIT, "", (Object)sftpProvideExtFlowStepBeginLogData);
            client.del(filePattern);
        }
        catch (NullPointerException ex) {
            String error = "Can not delete file [" + filePattern + "] on SFTP server [" + client.getInfo().getServer() + "]. Cause : Socket timeout occurs";
            throw new MessagingException(error);
        }
        catch (IOException ex) {
            String error = "Can not delete file [" + filePattern + "] on SFTP server [" + client.getInfo().getServer() + "]. IOException : " + ex.getMessage();
            throw new MessagingException(error);
        }
    }
}

