/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.petals.binding.soap.ServiceContext;
import org.ow2.petals.binding.soap.SoapComponent;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.incoming.PetalsAxisService;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.SoapServer;
import org.ow2.petals.binding.soap.util.ComponentPropertiesHelper;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.binding.soap.util.SoapSUClassLoader;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.BindingComponentServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.ClassLoaderUtil;
import org.w3c.dom.Document;

public class SoapSUManager
extends BindingComponentServiceUnitManager {
    private ComponentContext componentContext;
    private SoapComponentContext soapContext;
    private SoapComponent soapComponent;
    private Logger logger = null;
    private SoapServerConfig soapServerConfig;
    private PetalsReceiver petalsReceiver;

    public SoapSUManager(AbstractBindingComponent bindingComponent) {
        super(bindingComponent);
        this.soapComponent = (SoapComponent)bindingComponent;
    }

    protected void checkConsume(ConfigurationExtensions extensions) {
        if (SUPropertiesHelper.getServiceName(extensions) == null) {
            if (SUPropertiesHelper.getAddress(extensions) == null) {
                this.logger.warning("The field service-name can't be found into the consumes");
            } else {
                this.logger.info("The field address is deprecated, please use service-name");
            }
        }
    }

    protected void checkProvide(ConfigurationExtensions extensions) {
        if (SUPropertiesHelper.getWSATo(extensions) == null && SUPropertiesHelper.getAddress(extensions) == null && this.logger.isLoggable(Level.INFO)) {
            this.logger.info("The field 'wsa-to' isn't specified into the extensions. We'll search the WS-Addressing into the exchanges.");
        }
    }

    private void cleanServiceContexts(String serviceUnitName, Jbi descriptor) {
        this.soapContext.removeJbiDescriptor(serviceUnitName);
        this.soapContext.removeServiceDescriptor(serviceUnitName);
        List providesList = descriptor.getServices().getProvides();
        ServiceUnitDataHandler suDatahandler = null;
        for (Provides provides : providesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(provides);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Cleaning context for " + provides);
            }
            this.soapContext.getProvidersManager().deleteServiceContext(provides);
        }
        List consumesList = descriptor.getServices().getConsumes();
        for (Consumes consumes : consumesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(consumes);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Cleaning context for " + consumes);
            }
            this.soapContext.getConsumersManager().deleteServiceContext(consumes);
        }
    }

    private void createAxisService(Consumes consumes, File serviceDescriptor, ConfigurationExtensions extensions) throws PEtALSCDKException {
        String newServiceName = SUPropertiesHelper.getServiceName(extensions);
        if (newServiceName == null) {
            newServiceName = SUPropertiesHelper.getAddress(extensions);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("The deprecated address attribute is used. Service name: " + newServiceName);
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("The service name attribute is used. Service name: " + newServiceName);
        }
        try {
            AxisConfiguration axisConfig = this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration();
            if (axisConfig.getService(newServiceName) != null) {
                this.logger.log(Level.WARNING, "The service '" + newServiceName + "' is already registered in Axis, you cannot register it again");
            } else {
                PetalsAxisService axisService = new PetalsAxisService(newServiceName, this.componentContext, consumes, extensions, this.soapServerConfig, this.petalsReceiver, this.logger);
                axisService.setEnableAllTransports(false);
                this.setTransportHttpsToAxisService(axisService, this.component.getComponentExtensions(), extensions);
                this.setTransportHttpToAxisService(axisService, extensions);
                this.setTransportJmsToAxisService(axisService, extensions);
                QName jbiServiceQName = consumes.getServiceName();
                if (jbiServiceQName != null) {
                    axisService.setTargetNamespace(jbiServiceQName.getNamespaceURI());
                }
                axisService.addParameter(new Parameter("ServiceClass", (Object)"PetalsReceiver"));
                axisService.addParameter(new Parameter("sendStacktraceDetailsWithFaults", (Object)Boolean.TRUE));
                this.setServiceParametersToAxisService(axisService, consumes, serviceDescriptor);
                this.setModulesToAxisService(axisService, consumes);
            }
        }
        catch (AxisFault e) {
            throw new PEtALSCDKException("Can not register Service into Axis context", (Throwable)e);
        }
    }

    private void createServicesContext(String serviceUnitName, String suRootPath, Jbi descriptor) {
        ServiceUnitDataHandler suDatahandler = null;
        List providesList = descriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(provides);
            }
            ServiceContext<Provides> context = this.soapContext.getProvidersManager().createServiceContext(provides);
            ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions(provides);
            context.setModules(this.getModules(extensions));
            context.setServiceParams(this.getServiceParameters(extensions));
            context.setPolicyPath(this.getPolicyPath(suRootPath, extensions));
            context.setClassloader(this.getServiceClassloader(suRootPath));
        }
        List consumesList = descriptor.getServices().getConsumes();
        for (Consumes consumes : consumesList) {
            if (suDatahandler == null) {
                suDatahandler = this.getSUDataHandlerForService(consumes);
            }
            ServiceContext<Consumes> context = this.soapContext.getConsumersManager().createServiceContext(consumes);
            ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions(consumes);
            context.setModules(this.getModules(extensions));
            context.setServiceParams(this.getServiceParameters(extensions));
            context.setPolicyPath(this.getPolicyPath(suRootPath, extensions));
            context.setClassloader(this.getServiceClassloader(suRootPath));
        }
    }

    @Override
    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        this.logger.log(Level.FINE, "Deploying a new AxisService for SU " + serviceUnitName);
        this.soapContext.addJbiDescriptor(serviceUnitName, jbiDescriptor);
        File servicesXml = new File(suRootPath, "services.xml");
        if (servicesXml.exists()) {
            this.soapContext.addServiceDescriptor(serviceUnitName, servicesXml);
        }
        this.createServicesContext(serviceUnitName, suRootPath, jbiDescriptor);
    }

    @Override
    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = this.soapContext.getJbiDescriptor(serviceUnitName);
        File serviceDescription = this.soapContext.getServiceDescriptor(serviceUnitName);
        if (descriptor != null) {
            ServiceUnitDataHandler suDatahandler = null;
            List consumesList = descriptor.getServices().getConsumes();
            for (Consumes consumes : consumesList) {
                if (suDatahandler == null) {
                    suDatahandler = this.getSUDataHandlerForService(consumes);
                }
                ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions(consumes);
                this.checkConsume(extensions);
                this.createAxisService(consumes, serviceDescription, extensions);
                String redirect = SUPropertiesHelper.getHttpRedirection(extensions);
                if (redirect == null) continue;
                SoapServer httpServer = this.soapComponent.getExternalListenerManager().getHttpServer();
                String serviceName = SUPropertiesHelper.getServiceName(extensions);
                if (serviceName == null) {
                    serviceName = SUPropertiesHelper.getAddress(extensions);
                }
                StringTokenizer st = new StringTokenizer(redirect, ",;|");
                while (st.hasMoreTokens()) {
                    httpServer.addRedirect(st.nextToken().trim(), serviceName);
                }
            }
            List providesList = descriptor.getServices().getProvides();
            for (Provides provides : providesList) {
                if (suDatahandler == null) {
                    suDatahandler = this.getSUDataHandlerForService(provides);
                }
                ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions(provides);
                this.checkProvide(extensions);
                ServiceContext<Provides> context = this.soapContext.getProvidersManager().getServiceContext(provides);
                ServiceEndpoint srvEp = this.componentContext.getEndpoint(provides.getServiceName(), provides.getEndpointName());
                try {
                    Document doc = this.componentContext.getEndpointDescriptor(srvEp);
                    context.setServiceDescription(WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc));
                }
                catch (JBIException e) {
                    this.logger.warning("No endpoint descriptor found for the service endpoint : " + srvEp);
                }
                catch (WSDL4ComplexWsdlException e) {
                    this.logger.warning("Wsdl reading error" + e.getMessage());
                }
                catch (URISyntaxException e) {
                    this.logger.warning("Wsdl reading error" + e.getMessage());
                }
            }
        }
    }

    @Override
    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = this.soapContext.getJbiDescriptor(serviceUnitName);
        if (descriptor != null) {
            List consumesList = descriptor.getServices().getConsumes();
            for (Consumes consumes : consumesList) {
                ServiceUnitDataHandler suDatahandler = this.getSUDataHandlerForService(consumes);
                ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions(consumes);
                this.unregisterAxisService(extensions);
                String redirect = extensions.get((Object)"http-services-redirection");
                if (redirect == null) continue;
                StringTokenizer st = new StringTokenizer(redirect, ",;|");
                while (st.hasMoreTokens()) {
                    this.soapComponent.getExternalListenerManager().getHttpServer().removeRedirect(st.nextToken().trim());
                }
            }
            List providesList = descriptor.getServices().getProvides();
            for (Provides provides : providesList) {
                this.soapContext.deleteServiceClientPools(provides);
            }
        }
    }

    @Override
    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = this.getServiceUnitDataHandlers().get(serviceUnitName).getDescriptor();
        this.cleanServiceContexts(serviceUnitName, descriptor);
    }

    private List<String> getModules(ConfigurationExtensions extensions) {
        ArrayList<String> result = new ArrayList<String>();
        String token = extensions.get((Object)"modules");
        if (token != null) {
            StringTokenizer st = new StringTokenizer(token, ",");
            result.add("addressing");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    private File getPolicyPath(String suRootPath, ConfigurationExtensions extensions) {
        String policyPath = extensions.get((Object)"policy-path");
        File result = null;
        if (policyPath == null) {
            return result;
        }
        File path = new File(suRootPath, policyPath);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Setting policy path to " + path.getAbsolutePath());
        }
        if (path.exists() && path.isDirectory()) {
            result = path;
        } else {
            this.logger.warning("The policy path does not exists, it will be ignored " + path.getAbsolutePath());
        }
        return result;
    }

    private URLClassLoader getServiceClassloader(String suRootPath) {
        return ClassLoaderUtil.createClassLoader(suRootPath, Thread.currentThread().getContextClassLoader());
    }

    private String getServiceParameters(ConfigurationExtensions extensions) {
        return extensions.get((Object)"service-parameters");
    }

    public void init(SoapComponentContext soapContext, ComponentContext componentContext, SoapServerConfig soapServerConfig, PetalsReceiver petalsReceiver, Logger logger) {
        this.soapContext = soapContext;
        this.componentContext = componentContext;
        this.soapServerConfig = soapServerConfig;
        this.petalsReceiver = petalsReceiver;
        this.logger = logger;
    }

    private void setModulesToAxisService(AxisService axisService, Consumes consumes) throws DeploymentException, AxisFault {
        ArrayList<ClassLoader> suModulesClassLoaders = null;
        List<String> modules = this.soapContext.getConsumersManager().getModules(consumes);
        if (modules != null) {
            suModulesClassLoaders = new ArrayList<ClassLoader>();
            AxisConfiguration axisConfig = this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration();
            for (String module : modules) {
                AxisModule axisModule = axisConfig.getModule(module);
                if (axisModule == null) {
                    throw new DeploymentException(Messages.getMessage((String)"modulenotfound", (String)module));
                }
                axisService.addModuleref(axisModule.getName());
                suModulesClassLoaders.add(axisModule.getModuleClassLoader());
            }
            String suRootPath = this.getSUDataHandlerForConsumes(consumes).getInstallRoot();
            axisService.setClassLoader((ClassLoader)new SoapSUClassLoader(ClassLoaderUtil.getUrls(suRootPath), suModulesClassLoaders, axisService.getClassLoader()));
            this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration().addService(axisService);
            for (String module : modules) {
                AxisModule axisModule = axisConfig.getModule(module);
                if (axisService.isEngaged(axisModule)) continue;
                axisService.engageModule(axisModule, (AxisDescription)axisService);
            }
        }
    }

    private void setServiceParametersToAxisService(AxisService axisService, Consumes consumes, File serviceDescriptor) throws AxisFault {
        block9: {
            try {
                this.soapContext.getConsumersManager().addServiceParameters(consumes, axisService);
            }
            catch (XMLStreamException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(e.getMessage());
                }
            }
            catch (DeploymentException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block9;
                this.logger.warning(e.getMessage());
            }
        }
        if (serviceDescriptor != null) {
            try {
                FileInputStream fis = new FileInputStream(serviceDescriptor);
                ServiceBuilder builder = new ServiceBuilder((InputStream)fis, this.soapContext.getAxis2ConfigurationContext(), axisService);
                builder.populateService(builder.buildOM());
            }
            catch (XMLStreamException e) {
                this.logger.warning(e.getMessage());
            }
            catch (FileNotFoundException e) {
                this.logger.warning(e.getMessage());
            }
            catch (DeploymentException e) {
                this.logger.warning(e.getMessage());
            }
        }
    }

    private void setTransportHttpsToAxisService(AxisService axisService, ConfigurationExtensions componentExtensions, ConfigurationExtensions suExtensions) {
        if (ComponentPropertiesHelper.isHttpsEnabled(componentExtensions) && SUPropertiesHelper.isHttpsTransportEnabled(suExtensions)) {
            axisService.addExposedTransport("https");
            this.logger.log(Level.INFO, "The Axis2 service '" + axisService.getName() + "' has been registered and is available at '" + this.soapServerConfig.getServiceURL(axisService.getName(), "https") + "'");
        }
    }

    private void setTransportHttpToAxisService(AxisService axisService, ConfigurationExtensions extensions) {
        if (SUPropertiesHelper.isHttpTransportEnabled(extensions)) {
            axisService.addExposedTransport("http");
            this.logger.log(Level.INFO, "The Axis2 service '" + axisService.getName() + "' has been registered and is available at '" + this.soapServerConfig.getServiceURL(axisService.getName(), "http") + "'");
        }
    }

    private void setTransportJmsToAxisService(AxisService axisService, ConfigurationExtensions extensions) throws AxisFault {
        if (SUPropertiesHelper.isJmsTransportEnabled(extensions)) {
            axisService.addParameter(new Parameter("transport.jms.Destination", (Object)axisService.getName()));
            axisService.addExposedTransport("jms");
            this.logger.log(Level.INFO, "The Axis2 service '" + axisService.getName() + "' has been registered and is available through JMS.");
        }
    }

    private void unregisterAxisService(ConfigurationExtensions extensions) throws PEtALSCDKException {
        String serviceName = SUPropertiesHelper.getServiceName(extensions);
        if (serviceName == null) {
            serviceName = SUPropertiesHelper.getAddress(extensions);
        }
        AxisConfiguration axisConfig = this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration();
        this.logger.log(Level.INFO, "Removing Axis service '" + serviceName + "'");
        try {
            AxisService axisService = axisConfig.getService(serviceName);
            if (axisService != null) {
                axisConfig.removeServiceGroup(serviceName);
                axisService.getAxisConfiguration().removeService(serviceName);
            } else {
                this.logger.log(Level.WARNING, "Service '" + serviceName + "' not found, can not be unregistered from Axis2");
            }
        }
        catch (AxisFault e) {
            throw new PEtALSCDKException("Can not remove service from Axis context", (Throwable)e);
        }
    }
}

