/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.util.WsdlHelper;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PetalsAxisService
extends AxisService {
    private final ComponentContext componentContext;
    private final Consumes consumes;
    private final ConfigurationExtensions consumesExtensions;
    private final SoapServerConfig soapServerConfig;
    private final Map<QName, URI> operationMep;
    private final Logger logger;
    private PetalsReceiver petalsReceiver;
    private boolean initFromWSDLDone;
    public static final String OUTGOING_SERVICE_CLIENT_PREFIX = "OutgoingWSClient";
    public static final QName NOTIFY_OPERATION_NAME = QName.valueOf("/NotifyRequest");
    public static final QName GENERIC_OPERATION_NAME = QName.valueOf("PetalsGenericOperation");

    public PetalsAxisService(String name, ComponentContext componentContext, Consumes consumes, ConfigurationExtensions consumesExtensions, SoapServerConfig soapServerConfig, PetalsReceiver petalsReceiver, Logger logger) {
        super(name);
        this.componentContext = componentContext;
        this.consumes = consumes;
        this.soapServerConfig = soapServerConfig;
        this.logger = logger;
        this.consumesExtensions = consumesExtensions;
        this.operationMep = new HashMap<QName, URI>();
        this.petalsReceiver = petalsReceiver;
        this.initFromWSDLDone = false;
        InOutAxisOperation genericOperation = new InOutAxisOperation(GENERIC_OPERATION_NAME);
        genericOperation.setMessageReceiver((MessageReceiver)petalsReceiver);
        this.addOperation((AxisOperation)genericOperation);
        InOutAxisOperation notifyOperation = new InOutAxisOperation(NOTIFY_OPERATION_NAME);
        notifyOperation.setMessageReceiver((MessageReceiver)petalsReceiver);
        this.addOperation((AxisOperation)notifyOperation);
    }

    public void printWSDL(OutputStream out, String requestURI) throws AxisFault {
        block7: {
            this.logger.fine("Print WSDL");
            try {
                URI uri = new URI(requestURI);
                Document doc = this.getServiceDefinition(uri.getScheme());
                if (doc == null) {
                    this.printWSDLError(out, "WSDL description can not been retrieved from JBI endpoint");
                    break block7;
                }
                Description desc = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
                desc.deleteImportedDocumentsInWsdl(uri);
                Document descWithoutImport = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(desc);
                try {
                    XMLPrettyPrinter.prettify((Node)descWithoutImport, (OutputStream)out, (String)XMLPrettyPrinter.getEncoding((Document)descWithoutImport));
                }
                catch (Exception e) {
                    throw new AxisFault("Server", (Throwable)e);
                }
            }
            catch (WSDL4ComplexWsdlException e) {
                throw new AxisFault("Server", (Throwable)e);
            }
            catch (JBIException e) {
                throw new AxisFault("Server", (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new AxisFault("Server", (Throwable)e);
            }
        }
    }

    public Map<URI, Document> getImportedDocuments(String rootURI) throws AxisFault {
        try {
            URI uri = new URI(rootURI);
            Document doc = this.getServiceDefinition(uri.getScheme());
            if (doc == null) {
                throw new AxisFault("Server", "WSDL description can not been retrieved from JBI endpoint");
            }
            Description desc = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
            Map importsMap = desc.deleteImportedDocumentsInWsdl(uri);
            return importsMap;
        }
        catch (WSDL4ComplexWsdlException wsdl4cwe) {
            throw new AxisFault("Server", (Throwable)wsdl4cwe);
        }
        catch (JBIException jbie) {
            throw new AxisFault("Server", (Throwable)jbie);
        }
        catch (URISyntaxException urise) {
            throw new AxisFault("Server", (Throwable)urise);
        }
    }

    public void printWSDL2(OutputStream out, String requestIP) throws AxisFault {
        this.printWSDL(out, requestIP);
    }

    private void printWSDLError(OutputStream out, String message) {
        String wsdlntfound = "<error><description>Unable to get WSDL for this service</description><reason>" + message + "</reason></error>";
        this.printMessage(out, wsdlntfound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMessage(OutputStream out, String str) {
        try {
            out.write(str.getBytes());
            out.flush();
        }
        catch (IOException e) {
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
    }

    private Document getServiceDefinition(String transport) throws JBIException, WSDL4ComplexWsdlException, URISyntaxException {
        this.logger.fine("Get and update the service definition");
        Document result = null;
        ServiceEndpoint ep = this.getServiceEndpoint();
        if (ep != null && (result = this.componentContext.getEndpointDescriptor(ep)) != null) {
            result = WsdlHelper.replaceServiceAddressInWSDL(result, this.getServiceURL(transport));
        }
        return result;
    }

    public String getServiceURL(String transport) {
        return this.soapServerConfig.getServiceURL(this.getName(), transport);
    }

    public ServiceEndpoint getServiceEndpoint() {
        ServiceEndpoint[] endpoints;
        String endpointName = this.consumes.getEndpointName();
        QName serviceName = this.consumes.getServiceName();
        QName itf = this.consumes.getInterfaceName();
        Object jbiEndpoint = endpointName != null && serviceName != null ? this.componentContext.getEndpoint(serviceName, endpointName) : (serviceName != null ? ((endpoints = this.componentContext.getEndpointsForService(serviceName)) != null && endpoints.length > 0 ? endpoints[0] : null) : ((endpoints = this.componentContext.getEndpoints(itf)) != null && endpoints.length > 0 ? endpoints[0] : null));
        this.logger.fine("JBI Service endpoint " + jbiEndpoint);
        return jbiEndpoint;
    }

    public Map<QName, URI> getOperationMep() {
        return this.operationMep;
    }

    public ConfigurationExtensions getConsumesCDKExtensions() {
        return this.consumesExtensions;
    }

    public Consumes getConsumes() {
        return this.consumes;
    }

    public Description getDescription(String transport) throws AxisFault {
        try {
            Document doc = this.getServiceDefinition(transport);
            Description desc = doc != null ? WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc) : null;
            return desc;
        }
        catch (WSDL4ComplexWsdlException e) {
            throw new AxisFault("Server", (Throwable)e);
        }
        catch (JBIException e) {
            throw new AxisFault("Server", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new AxisFault("Server", (Throwable)e);
        }
    }

    public boolean wasAlreadyInitializedFromWSDL() {
        return this.initFromWSDLDone;
    }

    public void initFromWSDL() throws AxisFault {
        Description desc = this.getDescription("http");
        if (desc != null) {
            List bindings = desc.getBindings();
            for (Binding binding : bindings) {
                List operations = binding.getBindingOperations();
                for (BindingOperation operation : operations) {
                    InOutAxisOperation genericOperation = new InOutAxisOperation(operation.getQName());
                    genericOperation.setSoapAction(operation.getSoapAction());
                    genericOperation.setMessageReceiver((MessageReceiver)this.petalsReceiver);
                    this.addOperation((AxisOperation)genericOperation);
                }
            }
            this.getEndpoints().clear();
            Utils.addEndpointsToService((AxisService)this);
        }
        this.initFromWSDLDone = true;
    }
}

