/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import java.util.logging.Level;
import javax.servlet.Servlet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.JettyLogger;
import org.ow2.petals.binding.soap.listener.incoming.jetty.JettyNullLogger;
import org.ow2.petals.binding.soap.listener.incoming.jetty.PetalsErrorHandler;
import org.ow2.petals.binding.soap.listener.incoming.jetty.SOAPHttpTransportListener;
import org.ow2.petals.binding.soap.listener.incoming.jetty.SOAPHttpsTransportListener;
import org.ow2.petals.binding.soap.listener.incoming.jetty.ServerStats;
import org.ow2.petals.binding.soap.listener.incoming.servlet.ListServicesServlet;
import org.ow2.petals.binding.soap.listener.incoming.servlet.SoapServlet;
import org.ow2.petals.binding.soap.listener.incoming.servlet.WelcomeServlet;

public class SoapServer {
    protected java.util.logging.Logger logger;
    protected ConfigurationContext configurationContext;
    protected SoapServerConfig config;
    protected Server server;
    protected BoundedThreadPool threadPool;
    protected ServerStats stats;
    public static final int HEADER_BUFFER_SIZE = 16384;

    public SoapServer(SoapServerConfig config, SoapComponentContext componentContext, java.util.logging.Logger logger) throws AxisFault {
        this.config = config;
        this.logger = logger;
        this.configurationContext = componentContext.getAxis2ConfigurationContext();
        Log.setLog((Logger)new JettyLogger(logger));
        this.threadPool = new BoundedThreadPool();
        this.threadPool.setName("BCSoapJettyThreadPool");
        this.threadPool.setMaxThreads(this.config.getJettyThreadMaxPoolSize());
        this.threadPool.setMinThreads(this.config.getJettyThreadMinPoolSize());
        boolean isHttpsEnabled = this.config.isHttpsEnabled();
        SelectChannelConnector nioConnector = new SelectChannelConnector();
        nioConnector.setPort(this.config.getHttpPort());
        if (this.config.isRestricted()) {
            nioConnector.setHost(this.config.getHostAddress());
        }
        nioConnector.setHeaderBufferSize(16384);
        nioConnector.setStatsOn(false);
        nioConnector.setAcceptors(this.config.getJettyAcceptors());
        this.server = new Server();
        if (isHttpsEnabled) {
            String httpsTruststoreType;
            SslSelectChannelConnector nioSslConnector = new SslSelectChannelConnector();
            if (this.config.isRestricted()) {
                nioSslConnector.setHost(this.config.getHostAddress());
            }
            nioSslConnector.setPort(this.config.getHttpsPort());
            nioSslConnector.setHeaderBufferSize(16384);
            nioSslConnector.setStatsOn(false);
            nioSslConnector.setAcceptors(this.config.getJettyAcceptors());
            nioSslConnector.setNeedClientAuth(this.config.isHttpsClientAuthEnabled());
            nioSslConnector.setKeystore(this.config.getHttpsKeystoreFile());
            nioSslConnector.setPassword(this.config.getHttpsKeystorePassword());
            nioSslConnector.setKeyPassword(this.config.getHttpsKeystoreKeyPassword());
            String httpsKeystoreType = this.config.getHttpsKeystoreType();
            if (httpsKeystoreType != null) {
                nioSslConnector.setKeystoreType(httpsKeystoreType);
            }
            String httpsTruststoreFile = this.config.getHttpsTruststoreFile();
            String httpsTruststorePassword = this.config.getHttpsTruststorePassword();
            if (httpsTruststoreFile != null && httpsTruststorePassword != null) {
                nioSslConnector.setTruststore(httpsTruststoreFile);
                nioSslConnector.setTrustPassword(httpsTruststorePassword);
            }
            if ((httpsTruststoreType = this.config.getHttpsTruststoreType()) != null) {
                nioSslConnector.setTruststoreType(httpsTruststoreType);
            }
            this.server.setConnectors(new Connector[]{nioConnector, nioSslConnector});
        } else {
            this.server.setConnectors(new Connector[]{nioConnector});
        }
        this.server.setThreadPool((ThreadPool)this.threadPool);
        this.stats = new ServerStats();
        HandlerCollection contexts = new HandlerCollection();
        this.server.setHandler((Handler)contexts);
        Context axisContext = new Context((HandlerContainer)contexts, "/" + this.config.getServicesContext(), 1);
        axisContext.setErrorHandler((ErrorHandler)new PetalsErrorHandler(false));
        ServletHolder axisServlet = new ServletHolder((Servlet)new SoapServlet(this.configurationContext, this.stats));
        axisServlet.setName("AxisServlet");
        axisServlet.setInitOrder(1);
        axisContext.addServlet(axisServlet, "/" + this.config.getServicesMapping() + "/*");
        ServletHolder listServlet = new ServletHolder((Servlet)new ListServicesServlet(this.configurationContext, this.config));
        listServlet.setName("ServicesListServlet");
        listServlet.setInitOrder(1);
        axisContext.addServlet(listServlet, "/" + this.config.getServicesMapping() + "/" + "listServices");
        Context welcomeContext = new Context((HandlerContainer)contexts, "/", 1);
        ServletHolder welcomeServlet = new ServletHolder((Servlet)new WelcomeServlet(this.config, this.stats));
        welcomeServlet.setName("WelcomeServlet");
        welcomeServlet.setInitOrder(1);
        welcomeContext.addServlet(welcomeServlet, "/*");
        this.configureListenerManager();
    }

    private void configureListenerManager() throws AxisFault {
        ListenerManager listenerManager = this.configurationContext.getListenerManager();
        TransportInDescription httpTrsIn = new TransportInDescription("http");
        httpTrsIn.setReceiver((TransportListener)new SOAPHttpTransportListener(this.config));
        TransportInDescription httpsTrsIn = new TransportInDescription("https");
        httpsTrsIn.setReceiver((TransportListener)new SOAPHttpsTransportListener(this.config));
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
            listenerManager.init(this.configurationContext);
        }
        listenerManager.addListener(httpTrsIn, true);
        listenerManager.addListener(httpsTrsIn, true);
        listenerManager.setShutdownHookRequired(false);
    }

    public void start() throws AxisFault {
        this.logger.info("Starting HTTP(S)/SOAP server server...");
        this.logger.info(this.config.getHostToDisplay() + " - HTTP Port : " + this.config.getHttpPort() + " - HTTPS Port : " + this.config.getHttpsPort() + " / HTTP(S) server max poolsize : " + this.config.getJettyThreadMaxPoolSize() + " / HTTP(S) server min poolsize : " + this.config.getJettyThreadMinPoolSize() + " / HTTP(S) server acceptors size : " + this.config.getJettyAcceptors());
        try {
            this.stats.setStartTime(System.currentTimeMillis());
            this.server.start();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "Can not start the Jetty server");
            }
            throw new AxisFault("Can not start the HTTP(S)/SOAP server", (Throwable)e);
        }
    }

    public void stop() throws AxisFault {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Stopping HTTP(S)/SOAP server...");
        }
        try {
            this.server.stop();
            this.stats.setStopTime(System.currentTimeMillis());
        }
        catch (InterruptedException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public void shutdown() throws AxisFault {
        ListenerManager listenerManager;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Shuting down HTTP(S)/SOAP server...");
        }
        if ((listenerManager = this.configurationContext.getListenerManager()) != null) {
            listenerManager.destroy();
        }
        Log.setLog(null);
    }

    public void addRedirect(String from, String to) {
        this.config.addRedirect(from, "/" + this.config.getServicesContext() + "/" + this.config.getServicesMapping() + "/" + to);
    }

    public void removeRedirect(String from) {
        this.config.removeRedirect(from);
    }

    static {
        System.setProperty("org.mortbay.log.class", JettyNullLogger.class.getName());
        Log.getLog();
    }
}

