/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;

public class ListServicesServlet
extends HttpServlet {
    private static final long serialVersionUID = -4951673084170985493L;
    private static final String HTML_TOP = "<html><head><title>petals-bc-soap : Services List</title></head><body><h1>Petals BC SOAP</h1>";
    private static final String HTML_BOTTOM = "</body></html>";
    public static final String MAPPING_NAME = "listServices";
    private final transient ConfigurationContext configContext;
    private final transient SoapServerConfig soapServerConfig;

    public ListServicesServlet(ConfigurationContext configurationContext, SoapServerConfig soapConfig) {
        this.configContext = configurationContext;
        this.soapServerConfig = soapConfig;
    }

    private void listNotAvailable(ServletOutputStream out) throws IOException {
        out.write("<h1><font color='red'>The list of services is not available</font></h1>".getBytes());
        out.write("It must be activated in the SOAP component descriptor...".getBytes());
        out.write(HTML_BOTTOM.getBytes());
    }

    private void printServicesList(ServletOutputStream out, String transport) throws IOException {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        Set keys = services.keySet();
        out.write("<h2>Available services</h2>".getBytes());
        boolean atLeastOneService = false;
        if (keys.size() > 0) {
            for (Object key : keys) {
                List exposedTransports;
                AxisService service = (AxisService)services.get(key);
                if (service.getName().startsWith("OutgoingWSClient") || !(exposedTransports = service.getExposedTransports()).contains(transport)) continue;
                atLeastOneService = true;
                out.write("<li><a href='".getBytes());
                out.write(service.getName().getBytes());
                out.write("?wsdl'>".getBytes());
                out.write(service.getName().getBytes());
                out.write("</a></li>".getBytes());
            }
        }
        if (!atLeastOneService) {
            out.write("No service".getBytes());
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        out.write(HTML_TOP.getBytes());
        if (this.soapServerConfig.isProvidesList()) {
            this.printServicesList(out, request.getScheme());
        } else {
            this.listNotAvailable(out);
        }
        out.write(("<p><center><a href='" + this.soapServerConfig.getBaseURL(request.getScheme()) + "'> - Index -</a></center></p>").getBytes());
        out.write(HTML_BOTTOM.getBytes());
        out.flush();
        out.close();
    }
}

