/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;

public abstract class AbstractExternalServiceCaller {
    public static final String SOAP_VERSION_11 = "1.1";
    public static final String SOAP_VERSION_12 = "1.2";
    protected SoapComponentContext soapContext;
    protected Logger logger;

    public AbstractExternalServiceCaller(SoapComponentContext soapContext, Logger logger) {
        this.soapContext = soapContext;
        this.logger = logger;
    }

    protected static final String retrieveChunkedMode(ConfigurationExtensions extensions) {
        return extensions.get((Object)"chunked-mode");
    }

    protected static final boolean retrieveCleanupTransport(ConfigurationExtensions extensions) {
        String clean = extensions.get((Object)"cleanup-transport");
        if (clean == null) {
            return true;
        }
        return Boolean.valueOf(clean);
    }

    protected static final String retrieveDefaultSOAPAction(ConfigurationExtensions extensions) {
        String soapAction = extensions.get((Object)"soap-action");
        return soapAction;
    }

    protected static final HttpTransportProperties.ProxyProperties retrieveProxySettings(ConfigurationExtensions extensions) {
        HttpTransportProperties.ProxyProperties proxyProperties = null;
        if (extensions.get((Object)"proxy-host") != null) {
            proxyProperties = new HttpTransportProperties.ProxyProperties();
            String domain = extensions.get((Object)"proxy-domain");
            String password = extensions.get((Object)"proxy-password");
            String proxyHost = extensions.get((Object)"proxy-host");
            int proxyPort = -1;
            String tmp = extensions.get((Object)"proxy-port");
            if (tmp != null) {
                try {
                    proxyPort = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String proxyUserName = extensions.get((Object)"proxy-user");
            proxyProperties.setDomain(domain);
            proxyProperties.setPassWord(password);
            proxyProperties.setProxyName(proxyHost);
            proxyProperties.setProxyPort(proxyPort);
            proxyProperties.setUserName(proxyUserName);
        }
        return proxyProperties;
    }

    protected static final String retrieveSOAPEnvelopeNamespaceURI(ConfigurationExtensions extensions) {
        String soapEnvelopeNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
        String soapVersion = extensions.get((Object)"soap-version");
        if (SOAP_VERSION_12.equals(soapVersion)) {
            soapEnvelopeNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
        }
        return soapEnvelopeNamespaceURI;
    }

    protected abstract void call(Exchange var1, ConfigurationExtensions var2, Provides var3);

    protected abstract String getCallerType();

    protected final void handleException(Exchange exchange, AxisFault axisFault) {
        String message = null;
        message = axisFault.toString();
        if (axisFault.getCause() != null) {
            if (!message.isEmpty()) {
                message = message + ". ";
            }
            message = message + "The cause was " + axisFault.getCause().toString();
        }
        exchange.setError((Exception)((Object)new MessagingException("BC-SOAP Error => " + message)));
    }

    protected final void handleException(Exchange exchange, String errorMessage) {
        exchange.setError((Exception)((Object)new MessagingException("BC-SOAP Exception => " + errorMessage)));
    }

    protected static final void handleException(Exchange exchange, Exception t) {
        exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)t))));
    }
}

