/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.binding.soap.SoapComponent;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.outgoing.AbstractExternalServiceCaller;
import org.ow2.petals.binding.soap.listener.outgoing.JSONCaller;
import org.ow2.petals.binding.soap.listener.outgoing.RESTCaller;
import org.ow2.petals.binding.soap.listener.outgoing.SOAPCaller;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.SOAP11FaultServerException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;

public class JBIListener
extends AbstractJBIListener {
    protected Logger logger;
    protected SoapComponentContext soapContext;
    protected Map<String, AbstractExternalServiceCaller> callers;

    protected void addCaller(AbstractExternalServiceCaller caller) {
        this.callers.put(caller.getCallerType().toLowerCase(), caller);
    }

    @Override
    public void init() {
        this.soapContext = ((SoapComponent)this.getComponent()).getSoapContext();
        this.logger = this.getLogger();
        this.callers = new HashMap<String, AbstractExternalServiceCaller>(3);
        this.initCallers();
    }

    protected void initCallers() {
        this.addCaller(new SOAPCaller(this.soapContext, this.logger));
        this.addCaller(new RESTCaller(this.soapContext, this.logger));
        this.addCaller(new JSONCaller(this.soapContext, this.logger));
    }

    protected void invokeCaller(Exchange exchange) {
        ConfigurationExtensions extensions = this.getExtensions();
        String mode = SUPropertiesHelper.getMode(extensions);
        AbstractExternalServiceCaller caller = this.callers.get(mode.toLowerCase());
        if (caller == null) {
            try {
                exchange.setFault((Throwable)new SOAP11FaultServerException("No outgoing dispatcher found", new URI("http://petals.ow2.org/components/soap/version-4")));
            }
            catch (URISyntaxException e) {
                this.logger.log(Level.SEVERE, "Can't create SOAP11FaultServerException", e);
            }
            catch (MessagingException e) {
                this.logger.log(Level.SEVERE, "Can't return fault to consumer", e);
            }
        }
        if (caller != null) {
            caller.call(exchange, extensions, this.getProvides());
        }
    }

    @Override
    public boolean onJBIMessage(Exchange exchange) {
        if (exchange.isProviderRole()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("JBI message received on SOAP JBI listener");
            }
            this.invokeCaller(exchange);
        } else {
            this.logger.info("Role not supported in SOAP JBIListener : " + exchange.getRole());
        }
        return true;
    }
}

