/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.jaxen.JaxenException;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.outgoing.AbstractExternalServiceCaller;
import org.ow2.petals.binding.soap.util.AxiomUtils;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.binding.soap.util.StaxUtils;
import org.ow2.petals.binding.soap.util.URIBuilder;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;

public class RESTCaller
extends AbstractExternalServiceCaller {
    public static final String DEFAULT_HTTP_METHOD = "POST";

    protected static final String retrieveServiceAddress(Exchange exchange, ConfigurationExtensions extensions) {
        String address = null;
        try {
            Object object;
            if (exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing") != null && (object = exchange.getInMessageProperty("com.ebmwebsourcing.wsstar.addressing")) instanceof Document) {
                address = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType((Document)object).getAddress();
            }
        }
        catch (MessagingException e) {
        }
        catch (WSAddressingException wSAddressingException) {
            // empty catch block
        }
        if (address == null) {
            address = SUPropertiesHelper.getWSATo(extensions);
        }
        if (address == null) {
            address = SUPropertiesHelper.getAddress(extensions);
        }
        return address;
    }

    public RESTCaller(SoapComponentContext soapContext, Logger logger) {
        super(soapContext, logger);
    }

    protected URI buildEPR(String address, OMElement element) throws URISyntaxException {
        URIBuilder builder = URIBuilder.getInstance();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Set<String> set = builder.getParams(address);
        for (String xpathExpression : set) {
            String tmp = null;
            this.logger.fine("Getting parameter for " + xpathExpression);
            OMElement elt = null;
            try {
                AXIOMXPath axiomXPath = new AXIOMXPath(xpathExpression);
                elt = (OMElement)axiomXPath.selectSingleNode((Object)element);
            }
            catch (JaxenException e) {
                this.logger.warning("Bad XPATH expression : " + xpathExpression);
            }
            tmp = elt != null ? elt.getText() : "";
            this.logger.fine("Value for key '" + xpathExpression + "' is '" + tmp + "'");
            parameters.put(xpathExpression, tmp);
        }
        return builder.build(address, parameters);
    }

    protected OMElement buildMessageBody(QName operation, OMElement source) throws PEtALSCDKException, XMLStreamException, MessagingException {
        OMElement result = source;
        if (operation != null) {
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement rootElement = factory.createOMElement(operation);
            rootElement.addChild((OMNode)source);
            result = rootElement;
        }
        return result;
    }

    @Override
    public void call(Exchange exchange, ConfigurationExtensions extensions, Provides provides) {
        block9: {
            String address = RESTCaller.retrieveServiceAddress(exchange, extensions);
            if (address == null) {
                String message = "Can not define the REST service address to send message to";
                this.logger.warning("Can not define the REST service address to send message to");
                this.handleException(exchange, "Can not define the REST service address to send message to");
                return;
            }
            String httpMethod = this.getHTTPMethod(extensions);
            NormalizedMessage out = exchange.getOutMessage();
            this.logger.fine("Calling REST service on " + address);
            OMElement result = null;
            try {
                if (exchange.isInOutPattern()) {
                    OMElement omSource = this.sourceAsOMElement(exchange.getInMessageContentAsSource());
                    URI epr = this.buildEPR(address, omSource);
                    this.logger.fine("Final EPR for service call is : " + epr.toString());
                    Options options = this.createOptions(extensions, httpMethod, epr);
                    ServiceClient serviceClient = new ServiceClient();
                    serviceClient.setOptions(options);
                    OMElement message = this.buildMessageBody(exchange.getOperation(), omSource);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.getCallerType() + " MESSAGE : " + message.toString());
                    }
                    result = serviceClient.sendReceive(message);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.getCallerType() + " RESULT : " + result.toString());
                    }
                    if (result != null) {
                        out.setContent(AxiomUtils.createSource(result));
                    }
                    break block9;
                }
                throw new MessagingException("MEP not supported for " + this.getCallerType() + " caller : " + exchange.getPattern().toString());
            }
            catch (Throwable t) {
                this.logger.warning("Catch an exception on the " + this.getCallerType() + " invocation : " + t.getMessage());
                try {
                    exchange.setFault(t);
                }
                catch (MessagingException e1) {
                    this.logger.log(Level.SEVERE, "Can't return fault to consumer", e1);
                }
            }
        }
    }

    protected Options createOptions(ConfigurationExtensions extensions, String httpMethod, URI epr) {
        Options options = new Options();
        options.setTo(new EndpointReference(epr.toString()));
        options.setProperty("enableREST", (Object)"true");
        options.setProperty("HTTP_METHOD", (Object)httpMethod);
        long timeout = SUPropertiesHelper.retrieveTimeout(extensions);
        if (timeout != -1L) {
            options.setTimeOutInMilliSeconds(timeout);
        }
        return options;
    }

    @Override
    public String getCallerType() {
        return "REST";
    }

    protected String getHTTPMethod(ConfigurationExtensions extensions) {
        String rest = extensions.get((Object)"rest-http-method");
        if (rest == null) {
            rest = DEFAULT_HTTP_METHOD;
        }
        return rest;
    }

    protected OMElement sourceAsOMElement(Source source) throws PEtALSCDKException, XMLStreamException, MessagingException {
        Document contentSrc = UtilFactory.getSourceUtil().createDocument(source);
        XMLStreamReader parser = StaxUtils.createXMLStreamReader(new DOMSource(contentSrc));
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement document = builder.getDocumentElement();
        return document;
    }
}

