/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public final class AttachmentHelper {
    private AttachmentHelper() {
    }

    public static OMElement hasAttachmentElement(OMElement omElement, DataHandler dh, String cid) throws UnsupportedEncodingException {
        OMElement result = null;
        Iterator iter = omElement.getChildren();
        while (iter.hasNext() && result == null) {
            OMNode node = (OMNode)iter.next();
            if (!(node instanceof OMElement)) continue;
            OMElement element = (OMElement)node;
            OMAttribute attr = element.getAttribute(new QName("href"));
            if (attr != null) {
                if ("Include".equalsIgnoreCase(element.getLocalName()) && "http://www.w3.org/2004/08/xop/include".equalsIgnoreCase(element.getNamespace().getNamespaceURI())) {
                    if (!attr.getAttributeValue().substring(0, 3).equalsIgnoreCase("cid") || !AttachmentHelper.compare(attr.getAttributeValue().substring(4), cid)) continue;
                    result = (OMElement)element.getParent();
                    continue;
                }
                if (!attr.getAttributeValue().equals(cid)) continue;
                result = element;
                continue;
            }
            result = AttachmentHelper.hasAttachmentElement(element, dh, cid);
        }
        return result;
    }

    private static boolean compare(String text1, String text2) throws UnsupportedEncodingException {
        if (text1.equals(text2)) {
            return true;
        }
        if (text1.equals(text2 = URLEncoder.encode(text2, "UTF-8"))) {
            return true;
        }
        return (text1 = text1.replace("@", "%40")).equals(text2);
    }
}

