/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.ow2.petals.binding.soap.util.AxiomUtils;

public class AxiomSOAPEnvelopeFlattener {
    public SOAPEnvelope flatten(SOAPEnvelope sourceEnv) throws AxisFault {
        SOAPFactory factory = AxiomUtils.getSOAPFactory(sourceEnv);
        SOAPEnvelope targetEnv = factory.createSOAPEnvelope(sourceEnv.getNamespace());
        AxiomUtils.copyTagData((OMElement)sourceEnv, (OMElement)targetEnv);
        Map<String, OMElement> multiref = AxiomUtils.getHrefElements((OMElement)sourceEnv);
        if (multiref.size() == 0) {
            return sourceEnv;
        }
        Iterator i = sourceEnv.getChildren();
        while (i.hasNext()) {
            OMNode child;
            Iterator j;
            OMNode node = (OMNode)i.next();
            if (node instanceof SOAPHeader) {
                SOAPHeader targetHeader = factory.createSOAPHeader(targetEnv);
                j = ((SOAPHeader)node).getChildren();
                while (j.hasNext()) {
                    child = (OMNode)j.next();
                    this.flatten(factory, (OMContainer)targetHeader, child, multiref);
                }
                continue;
            }
            if (node instanceof SOAPBody) {
                SOAPBody targetBody = factory.createSOAPBody(targetEnv);
                j = ((SOAPBody)node).getChildren();
                while (j.hasNext()) {
                    child = (OMNode)j.next();
                    this.flatten(factory, (OMContainer)targetBody, child, multiref);
                }
                continue;
            }
            AxiomUtils.copy(factory, (OMContainer)targetEnv, node);
        }
        return targetEnv;
    }

    private void flatten(SOAPFactory factory, OMContainer targetParent, OMNode sourceNode, Map<String, OMElement> multirefs) {
        if (sourceNode instanceof SOAPFault) {
            AxiomUtils.copySOAPFault(factory, targetParent, (SOAPFault)sourceNode);
        } else if (sourceNode instanceof OMElement) {
            OMElement element = (OMElement)sourceNode;
            if (!AxiomUtils.isMultirefElement(element)) {
                if (AxiomUtils.isHrefRedirect(element)) {
                    this.flattenOMElement(factory, targetParent, element, multirefs);
                } else {
                    OMElement newElement = factory.createOMElement(element.getQName(), targetParent);
                    AxiomUtils.copyTagData(element, newElement);
                    Iterator j = element.getChildren();
                    while (j.hasNext()) {
                        OMNode child = (OMNode)j.next();
                        this.flatten(factory, (OMContainer)newElement, child, multirefs);
                    }
                }
            }
        } else if (sourceNode instanceof OMText) {
            AxiomUtils.copyOMText(factory, targetParent, (OMText)sourceNode);
        } else if (sourceNode instanceof OMComment) {
            AxiomUtils.copyOMComment(factory, targetParent, (OMComment)sourceNode);
        } else {
            throw new OMException("Internal Failure: Cannot make a copy of " + sourceNode.getClass().getName());
        }
    }

    public void flattenOMElement(SOAPFactory factory, OMContainer targetParent, OMElement sourceElement, Map<String, OMElement> multiref) {
        String id = AxiomUtils.getHrefId(sourceElement);
        OMElement href = multiref.get(id);
        OMElement newElement = factory.createOMElement(sourceElement.getQName());
        AxiomUtils.copyTagData(sourceElement, newElement);
        AxiomUtils.copyTagData(href, newElement);
        Iterator i = href.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            this.flatten(factory, (OMContainer)newElement, node, multiref);
        }
        targetParent.addChild((OMNode)newElement);
    }
}

