/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SUPropertiesHelper {
    protected static final boolean checkPresent(String parameterName, ConfigurationExtensions extensions) {
        String tmp = extensions.get((Object)parameterName);
        return tmp != null && tmp.trim().length() > 0;
    }

    @Deprecated
    public static String getAddress(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("address", extensions);
    }

    protected static final boolean getBoolean(String parameterName, ConfigurationExtensions extensions) {
        boolean result = true;
        String tmp = extensions.get((Object)parameterName);
        if (tmp != null) {
            result = Boolean.parseBoolean(tmp.trim());
        }
        return result;
    }

    protected static final boolean getBoolean(String parameterName, ConfigurationExtensions extensions, boolean defaultValue) {
        boolean result = true;
        String tmp = extensions.get((Object)parameterName);
        result = tmp == null ? defaultValue : Boolean.parseBoolean(tmp.trim());
        return result;
    }

    public static final String getHttpRedirection(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("http-services-redirection", extensions);
    }

    public static String getMode(ConfigurationExtensions extensions) {
        if (extensions == null) {
            return "SOAP";
        }
        return SUPropertiesHelper.getString("mode", "SOAP", extensions);
    }

    public static String getServiceName(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("service-name", extensions);
    }

    protected static final String getString(String parameterName, ConfigurationExtensions extensions) {
        String result = extensions.get((Object)parameterName);
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    protected static final String getString(String parameterName, String defaultValue, ConfigurationExtensions extensions) {
        String result = SUPropertiesHelper.getString(parameterName, extensions);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static String getWSAFaultTo(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-faultto", extensions);
    }

    public static String getWSAFrom(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-from", extensions);
    }

    public static String getWSAReplyTo(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-replyto", extensions);
    }

    public static String getWSATo(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-to", extensions);
    }

    public static boolean isHttpsTransportEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("enable-https-transport", extensions, false);
    }

    public static boolean isHttpTransportEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("enable-http-transport", extensions);
    }

    public static boolean isJmsTransportEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("enable-jms-transport", extensions, false);
    }

    public static boolean isPolicyEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.checkPresent("policy-path", extensions);
    }

    public static final boolean isRESTMode(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getMode(extensions) != null && SUPropertiesHelper.getMode(extensions).equalsIgnoreCase("REST");
    }

    public static final boolean isServiceMode(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getMode(extensions) != null && (SUPropertiesHelper.getMode(extensions).equalsIgnoreCase("SOAP") || SUPropertiesHelper.getMode(extensions).equalsIgnoreCase("REST") || SUPropertiesHelper.getMode(extensions).equalsIgnoreCase("JSON"));
    }

    public static final boolean isSOAPMode(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getMode(extensions) != null && SUPropertiesHelper.getMode(extensions).equalsIgnoreCase("SOAP");
    }

    public static List<String> retrieveHeaderList(ConfigurationExtensions extensions) {
        ArrayList<String> result = null;
        String tmp = extensions.get((Object)"headers-filter");
        if (tmp != null) {
            result = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(tmp, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public static boolean retrieveInjectHeader(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("inject-headers", extensions);
    }

    public static String retrieveRESTAddNSPrefixOnRequest(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("rest-add-namespace-prefix", "soapbc", extensions);
    }

    public static String retrieveRESTAddNSURIOnRequest(ConfigurationExtensions extensions) {
        return extensions.get((Object)"rest-add-namespace-uri");
    }

    public static List<String> retrieveRESTRemovePrefixOnResponse(ConfigurationExtensions extensions) {
        ArrayList<String> result = null;
        String tmp = extensions.get((Object)"rest-remove-prefix-on-response");
        if (tmp != null) {
            result = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(tmp, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public static final long retrieveTimeout(ConfigurationExtensions extensions) {
        long timeout = -1L;
        String timeoutStr = extensions.get((Object)"synchronous-timeout");
        if (timeoutStr != null) {
            timeout = Long.parseLong(timeoutStr);
        }
        return timeout;
    }

    protected SUPropertiesHelper() {
    }

    public static List<DocumentFragment> retrieveHeaderToInject(ConfigurationExtensions extensions) {
        String toInject = SUPropertiesHelper.getString("headers-to-inject", extensions);
        if (toInject == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader("<R>" + toInject + "</R>")));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
        Element root = doc.getDocumentElement();
        ArrayList<DocumentFragment> result = null;
        while (root.hasChildNodes()) {
            DocumentFragment docfrag = doc.createDocumentFragment();
            docfrag.appendChild(root.removeChild(root.getFirstChild()));
            if (result == null) {
                result = new ArrayList<DocumentFragment>();
            }
            result.add(docfrag);
        }
        return result;
    }

    public static boolean isAxis1CompatibilityEnabled(ConfigurationExtensions extensions) {
        String compatibility = extensions.get((Object)"enable-compatibility-for");
        return compatibility != null && compatibility.equals("AXIS1");
    }

    public static String getKeystoreFile(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-keystore-file");
    }

    public static String getKeystorePassword(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-keystore-password");
    }

    public static String getTruststoreFile(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-truststore-file");
    }

    public static String getTruststorePassword(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-truststore-password");
    }

    public static boolean isWSAEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.checkPresent("wsa-use", extensions);
    }
}

