/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class URIBuilder {
    private static URIBuilder instance = null;

    public static URIBuilder getInstance() {
        return instance;
    }

    private URIBuilder() {
    }

    public URI build(String pattern, Map<String, String> parameters) throws URISyntaxException {
        URI result = null;
        String tmp = pattern;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            try {
                String param = entry.getValue();
                param = param.replace("&amp;", "&");
                param = URLEncoder.encode(param, "UTF-8");
                param = param.replace("%23", "#");
                param = param.replace("%26", "&");
                param = param.replace("%3F", "?");
                param = param.replace("%3D", "=");
                tmp = tmp.replace("{" + entry.getKey() + "}", param);
            }
            catch (UnsupportedEncodingException e) {}
        }
        tmp = tmp.replace("&amp;", "&");
        result = new URI(tmp);
        return result;
    }

    public Set<String> getParams(String uriPattern) {
        HashSet<String> result = new HashSet<String>();
        int start = 0;
        while ((start = uriPattern.indexOf("{")) > -1 && uriPattern.indexOf("}") >= uriPattern.indexOf("{")) {
            int stop = uriPattern.indexOf("}");
            String placeholder = uriPattern.substring(start + 1, stop);
            uriPattern = uriPattern.substring(stop + 1, uriPattern.length());
            result.add(placeholder);
        }
        return result;
    }

    static {
        instance = new URIBuilder();
    }
}

