/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.util.Util;
import org.w3c.dom.Document;

public class WsdlHelper {
    private WsdlHelper() {
    }

    public static final Document replaceServiceAddressInWSDL(Document doc, String address) throws WSDL4ComplexWsdlException, URISyntaxException {
        Document result = null;
        WSDL4ComplexWsdlFactory wsdlFactory = WSDL4ComplexWsdlFactory.newInstance();
        WSDL4ComplexWsdlWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        WSDL4ComplexWsdlReader reader = wsdlFactory.newWSDLReader();
        Description desc = reader.read(doc);
        List services = desc.getServices();
        for (Service service : services) {
            List endpoints = service.getEndpoints();
            for (Endpoint endpoint : endpoints) {
                endpoint.setAddress(address);
            }
        }
        result = wsdlWriter.getDocument(desc);
        return result;
    }

    public static final Map<String, String> readAndStoreSoapAction(Document doc, QName serviceName, String endpointName) throws WSDL4ComplexWsdlException, URISyntaxException {
        HashMap<String, String> map = new HashMap<String, String>();
        Description desc = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
        Service srv = (Service)desc.getService(serviceName);
        Endpoint ep = (Endpoint)srv.getEndpoint(endpointName);
        Binding bd = (Binding)ep.getBinding();
        if (bd == null) {
            return map;
        }
        List bOperations = bd.getBindingOperations();
        for (BindingOperation op : bOperations) {
            map.put(op.getQName().getLocalPart(), op.getSoapAction());
        }
        return map;
    }

    public static BindingOperation findOperationUsingElement(org.w3c.dom.Element firstElement, Description desc, String endpointName, QName serviceName) {
        BindingOperation result = null;
        BindingOperation guess = null;
        Binding b = (Binding)((Endpoint)((Service)desc.getService(serviceName)).getEndpoint(endpointName)).getBinding();
        if (firstElement != null) {
            for (BindingOperation op : b.getBindingOperations()) {
                if (op.getStyle().equals((Object)AbsItfBinding.StyleConstant.RPC)) {
                    if (!((Operation)op.getOperation()).getQName().getNamespaceURI().equals(firstElement.getNamespaceURI()) || !((Operation)op.getOperation()).getQName().getLocalPart().equals(firstElement.getLocalName())) continue;
                    result = op;
                    break;
                }
                QName elmtName = new QName(firstElement.getNamespaceURI(), Util.getLocalPartWithoutPrefix((String)firstElement.getNodeName()));
                Element e = ((Input)((Operation)op.getOperation()).getInput()).getElement();
                if (e == null || e.getQName() == null || !e.getQName().getLocalPart().equals(elmtName.getLocalPart())) continue;
                guess = op;
                if (!e.getQName().getNamespaceURI().equals(elmtName.getNamespaceURI())) continue;
                result = op;
                break;
            }
        }
        if (result == null) {
            result = guess;
        }
        return result;
    }

    public static BindingOperation findOperationUsingSoapAction(String soapAction, Description desc) {
        BindingOperation res = null;
        boolean find = false;
        for (Binding b : desc.getBindings()) {
            for (BindingOperation op : b.getBindingOperations()) {
                if (op.getSoapAction() == null || !op.getSoapAction().equals(soapAction)) continue;
                res = op;
                find = true;
                break;
            }
            if (!find) continue;
            break;
        }
        return res;
    }

    public static String findSoapAction(org.w3c.dom.Element firstElement, Description desc, String endpointName, QName serviceName) {
        BindingOperation op = WsdlHelper.findOperationUsingElement(firstElement, desc, endpointName, serviceName);
        if (op != null) {
            return op.getSoapAction();
        }
        return "";
    }
}

