/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIOperationDispatcher;
import org.apache.axis2.dispatchers.SOAPActionBasedDispatcher;
import org.apache.axis2.dispatchers.SOAPMessageBodyBasedDispatcher;
import org.apache.axis2.receivers.RawXMLINOnlyMessageReceiver;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.binding.soap.axis.Axis2Config;
import org.ow2.petals.binding.soap.axis.HandlerConfig;
import org.ow2.petals.binding.soap.axis.MessageReceiverConfig;
import org.ow2.petals.binding.soap.axis.PhaseConfig;
import org.ow2.petals.binding.soap.axis.PhaseOrderConfig;
import org.ow2.petals.binding.soap.axis.TransportReceiverConfig;

public class Axis2ConfigTest {
    private static final String AXIS2_CONFIG_TEST0 = "Axis2ConfigTest0.xml";

    @Test
    public void testDumpXml() throws Exception {
        InputStream expected = this.getClass().getClassLoader().getResourceAsStream(AXIS2_CONFIG_TEST0);
        Axis2Config axis2Config = new Axis2Config("axis2Config");
        axis2Config.addParameter("hotdeployment", "true");
        axis2Config.addParameter("hotupdate", "false");
        MessageReceiverConfig inOnlyReceiverConfig = new MessageReceiverConfig("http://www.w3.org/2004/08/wsdl/in-only", RawXMLINOnlyMessageReceiver.class);
        MessageReceiverConfig inOutReceiverConfig = new MessageReceiverConfig("http://www.w3.org/2004/08/wsdl/in-out", RawXMLINOutMessageReceiver.class);
        axis2Config.addMessageReceiver(inOnlyReceiverConfig);
        axis2Config.addMessageReceiver(inOutReceiverConfig);
        TransportReceiverConfig httpServerReceiverConfig = new TransportReceiverConfig("http", SimpleHTTPServer.class);
        httpServerReceiverConfig.addParameter("port", "8080");
        axis2Config.addTransportReceiver(httpServerReceiverConfig);
        HandlerConfig requestURIBasedDispatcherConfig = new HandlerConfig("RequestURIBasedDispatcher", RequestURIBasedDispatcher.class);
        HandlerConfig soapActionBasedDispatcherConfig = new HandlerConfig("SOAPActionBasedDispatcher", SOAPActionBasedDispatcher.class);
        PhaseConfig transportPhaseConfig = new PhaseConfig("Transport");
        transportPhaseConfig.addHandler(requestURIBasedDispatcherConfig);
        transportPhaseConfig.addHandler(soapActionBasedDispatcherConfig);
        PhaseConfig securityPhaseConfig = new PhaseConfig("Security");
        PhaseConfig preDispatchPhaseConfig = new PhaseConfig("PreDispatch");
        HandlerConfig requestURIOperationDispatcherConfig = new HandlerConfig("RequestURIOperationDispatcher", RequestURIOperationDispatcher.class);
        HandlerConfig soapMessageBodyBasedDispatcherConfig = new HandlerConfig("SOAPMessageBodyBasedDispatcher", SOAPMessageBodyBasedDispatcher.class);
        PhaseConfig dispatchPhaseConfig = new PhaseConfig("Dispatch");
        dispatchPhaseConfig.addHandler(requestURIOperationDispatcherConfig);
        dispatchPhaseConfig.addHandler(soapMessageBodyBasedDispatcherConfig);
        PhaseOrderConfig inFlowConfig = new PhaseOrderConfig("InFlow");
        inFlowConfig.addPhase(transportPhaseConfig);
        inFlowConfig.addPhase(securityPhaseConfig);
        inFlowConfig.addPhase(preDispatchPhaseConfig);
        inFlowConfig.addPhase(dispatchPhaseConfig);
        axis2Config.addPhaseOrder(inFlowConfig);
        StringWriter sw = new StringWriter();
        axis2Config.dump((Writer)sw);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)expected, (InputStream)new ByteArrayInputStream(sw.getBuffer().toString().getBytes())));
    }
}

