/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.ow2.petals.binding.soap.axis.AbstractAxis2RepositoryBasedObject;
import org.ow2.petals.binding.soap.axis.Axis2Config;
import org.ow2.petals.binding.soap.listener.outgoing.PetalsServiceClient;

public class Axis2Client
extends AbstractAxis2RepositoryBasedObject {
    private final URL wsdlURL;
    private final QName wsdlServiceName;
    private final String portName;
    private final Logger logger;
    private PetalsServiceClient petalsServiceClient;

    public Axis2Client(File baseDir, Axis2Config config, URL wsdlURL, QName wsdlServiceName, String portName, Logger logger) {
        super(baseDir, config);
        this.wsdlURL = wsdlURL;
        this.wsdlServiceName = wsdlServiceName;
        this.portName = portName;
        this.logger = logger;
        this.petalsServiceClient = null;
    }

    @Override
    protected void specificSetUp() {
        super.specificSetUp();
        try {
            this.petalsServiceClient = new PetalsServiceClient(this.getConfigurationContext(), this.wsdlURL, this.wsdlServiceName, this.portName);
            this.petalsServiceClient.setLogger(this.logger);
        }
        catch (AxisFault af) {
            throw new UncheckedException((Throwable)af);
        }
    }

    public void submitRequestInOutMep(String operationName, String soapBody) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = this.createXmlPayloadInOMElement(soapBody);
        try {
            this.petalsServiceClient.sendReceive(operationQName, xmlPayload, null);
        }
        catch (AxisFault af) {
            throw new UncheckedException((Throwable)af);
        }
    }

    public void submitRequestInOnlyMep(String operationName, String soapBody) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = this.createXmlPayloadInOMElement(soapBody);
        try {
            this.petalsServiceClient.fireAndForget(operationQName, xmlPayload, null);
        }
        catch (AxisFault af) {
            throw new UncheckedException((Throwable)af);
        }
    }

    public void submitRequestRobustInOnlyMep(String operationName, String soapBody) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = this.createXmlPayloadInOMElement(soapBody);
        try {
            this.petalsServiceClient.sendRobust(operationQName, xmlPayload, null);
        }
        catch (AxisFault af) {
            throw new UncheckedException((Throwable)af);
        }
    }

    public void submitRequestWithAttachments(String operationName, String soapBody, Map<String, DataHandler> attachments) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = this.createXmlPayloadInOMElement(soapBody);
        try {
            this.petalsServiceClient.getOptions().setProperty("enableMTOM", (Object)"true");
            this.petalsServiceClient.sendReceive(operationQName, xmlPayload, null);
        }
        catch (AxisFault af) {
            throw new UncheckedException((Throwable)af);
        }
    }

    private OMElement createXmlPayloadInOMElement(String soapBody) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(soapBody.getBytes());
        OMElement xmlPayload = null;
        try {
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)inputStream);
            xmlPayload = builder.getDocumentElement();
        }
        catch (XMLStreamException xse) {
            throw new UncheckedException((Throwable)xse);
        }
        return xmlPayload;
    }
}

