/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.ow2.petals.binding.soap.util.NetworkUtil;

public class SoapServerConfig {
    private int httpPort;
    private String host;
    private InetAddress hostIP;
    private String servicesMapping;
    private String servicesContext;
    private boolean restricted;
    private boolean isHttpsEnabled;
    private int httpsPort;
    private String httpsKeystoreType;
    private String httpsKeytoreFile;
    private String httpsKeytorePassword;
    private String httpsKeytoreKeyPassword;
    private String httpsTruststoreType;
    private String httpsTruststoreFile;
    private String httpsTruststorePassword;
    private boolean providesList;
    private HashMap<String, String> redirects;
    protected int jettyThreadMaxPoolSize;
    protected int jettyThreadMinPoolSize;
    protected int jettyAcceptors;
    private boolean isValidHostName;

    public SoapServerConfig(Logger logger, String host, int httpPort) {
        this.setHost(logger, host);
        this.httpPort = httpPort;
        this.isHttpsEnabled = false;
        this.servicesContext = "petals";
        this.servicesMapping = "services";
        this.jettyAcceptors = 4;
        this.jettyThreadMinPoolSize = 2;
        this.jettyThreadMaxPoolSize = 255;
        this.servicesContext = "petals";
        this.servicesMapping = "services";
    }

    private void setHost(Logger logger, String host) {
        block11: {
            try {
                InetAddress address;
                Set<Inet4Address> localIPv4Addresses;
                block12: {
                    localIPv4Addresses = NetworkUtil.getAllLocalIPv4InetAddresses();
                    if (host == null || host.length() == 0 || host.equals("null")) {
                        try {
                            this.hostIP = SoapServerConfig.getIPv4AddressForHost(localIPv4Addresses);
                            this.isValidHostName = true;
                            this.restricted = false;
                        }
                        catch (UnknownHostException uhe) {
                            this.isValidHostName = false;
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.log(Level.WARNING, uhe.getMessage(), uhe);
                            }
                            break block11;
                        }
                    }
                    address = null;
                    try {
                        address = InetAddress.getByName(host);
                    }
                    catch (UnknownHostException uhe) {
                        this.isValidHostName = false;
                        if (!logger.isLoggable(Level.WARNING)) break block12;
                        logger.log(Level.WARNING, uhe.getMessage(), uhe);
                    }
                }
                if (localIPv4Addresses.contains(address)) {
                    this.hostIP = address;
                    this.isValidHostName = true;
                    this.host = host;
                    this.restricted = true;
                } else {
                    this.isValidHostName = false;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, host + " does not correspond to a local host");
                    }
                }
            }
            catch (SocketException se) {
                this.isValidHostName = false;
                if (!logger.isLoggable(Level.WARNING)) break block11;
                logger.log(Level.WARNING, se.getMessage(), se);
            }
        }
    }

    private static final InetAddress getIPv4AddressForHost(Set<Inet4Address> localIPv4Addresses) throws UnknownHostException {
        InetAddress ipAddress = null;
        InetAddress hostIPv4Address = null;
        if (localIPv4Addresses != null && localIPv4Addresses.size() > 0) {
            Iterator<Inet4Address> localIPv4AddressesIter = localIPv4Addresses.iterator();
            while (localIPv4AddressesIter.hasNext() && hostIPv4Address == null) {
                InetAddress ipv4Addressr = localIPv4AddressesIter.next();
                if (ipv4Addressr.isLoopbackAddress()) continue;
                hostIPv4Address = ipv4Addressr;
            }
        }
        ipAddress = hostIPv4Address == null ? InetAddress.getLocalHost() : hostIPv4Address;
        return ipAddress;
    }

    public boolean isValidHostName() {
        return this.isValidHostName;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public String getHostAddress() {
        return this.hostIP.getHostAddress();
    }

    public String getHostToDisplay() {
        String hostToDisplay;
        if (!this.isValidHostName) {
            hostToDisplay = "Invalid Host Name";
        } else if (this.isRestricted()) {
            String ipAddress = this.hostIP.getHostAddress();
            if (ipAddress.equals(this.host)) {
                hostToDisplay = "Host : " + ipAddress;
            } else {
                String hostName = this.hostIP.getHostName();
                hostToDisplay = "Host : " + ipAddress + " (" + hostName + ")";
            }
        } else {
            try {
                Set<Inet4Address> localIPv4Addresses = NetworkUtil.getAllLocalIPv4InetAddresses();
                Iterator<Inet4Address> localIPv4AddressesIterator = localIPv4Addresses.iterator();
                StringBuffer hostList = new StringBuffer("Hosts : ");
                while (localIPv4AddressesIterator.hasNext()) {
                    String ipAddress;
                    Inet4Address localIPv4Address = localIPv4AddressesIterator.next();
                    String hostName = localIPv4Address.getHostName();
                    if (hostName.equals(ipAddress = localIPv4Address.getHostAddress())) {
                        hostList.append(ipAddress);
                    } else {
                        hostList.append(ipAddress + " (" + hostName + ")");
                    }
                    if (!localIPv4AddressesIterator.hasNext()) continue;
                    hostList.append(" / ");
                }
                hostToDisplay = hostList.toString();
            }
            catch (SocketException e) {
                hostToDisplay = "Host : Unable to display the host names";
                e.printStackTrace();
            }
        }
        return hostToDisplay;
    }

    public int getJettyAcceptors() {
        return this.jettyAcceptors;
    }

    public int getJettyThreadMaxPoolSize() {
        return this.jettyThreadMaxPoolSize;
    }

    public int getJettyThreadMinPoolSize() {
        return this.jettyThreadMinPoolSize;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getServicesContext() {
        return this.servicesContext;
    }

    public String getServicesMapping() {
        return this.servicesMapping;
    }

    public boolean isProvidesList() {
        return this.providesList;
    }

    public boolean isHttpsEnabled() {
        return this.isHttpsEnabled;
    }

    public String getHttpsKeystoreType() {
        return this.httpsKeystoreType;
    }

    public String getHttpsKeystoreFile() {
        return this.httpsKeytoreFile;
    }

    public String getHttpsKeystorePassword() {
        return this.httpsKeytorePassword;
    }

    public String getHttpsKeystoreKeyPassword() {
        return this.httpsKeytoreKeyPassword;
    }

    public String getHttpsTruststoreType() {
        return this.httpsTruststoreType;
    }

    public String getHttpsTruststoreFile() {
        return this.httpsTruststoreFile;
    }

    public String getHttpsTruststorePassword() {
        return this.httpsTruststorePassword;
    }

    public void setJettyAcceptors(int jettyAcceptors) {
        this.jettyAcceptors = jettyAcceptors;
    }

    public void setJettyThreadMaxPoolSize(int jettyThreadMaxPoolSize) {
        this.jettyThreadMaxPoolSize = jettyThreadMaxPoolSize;
    }

    public void setJettyThreadMinPoolSize(int jettyThreadMinPoolSize) {
        this.jettyThreadMinPoolSize = jettyThreadMinPoolSize;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public void setHttpsPort(int port) {
        this.httpsPort = port;
    }

    public void setProvidesList(boolean providesList) {
        this.providesList = providesList;
    }

    public void setRestrict(boolean restricted) {
        this.restricted = restricted;
    }

    public void setServicesContext(String servicesContext) {
        this.servicesContext = servicesContext;
    }

    public void setServicesMapping(String servicesMapping) {
        this.servicesMapping = servicesMapping;
    }

    public void setHttpsEnabled(boolean isHttpsEnabled) {
        this.isHttpsEnabled = isHttpsEnabled;
    }

    public void setHttpsKeytoreType(String httpsKeystoreType) {
        this.httpsKeystoreType = httpsKeystoreType;
    }

    public void setHttpsKeytoreFile(String httpsKeytoreFile) {
        this.httpsKeytoreFile = httpsKeytoreFile;
    }

    public void setHttpsKeytorePassword(String httpsKeytorePassword) {
        this.httpsKeytorePassword = httpsKeytorePassword;
    }

    public void setHttpsKeyPassword(String httpsKeytoreKeyPassword) {
        this.httpsKeytoreKeyPassword = httpsKeytoreKeyPassword;
    }

    public void setHttpsTruststoreType(String httpsTruststoreType) {
        this.httpsTruststoreType = httpsTruststoreType;
    }

    public void setHttpsTruststoreFile(String httpsTruststoreFile) {
        this.httpsTruststoreFile = httpsTruststoreFile;
    }

    public void setHttpsTruststorePassword(String httpsTruststorePassword) {
        this.httpsTruststorePassword = httpsTruststorePassword;
    }

    public EndpointReference[] getEPRsForAxisService(String serviceName, String transport) throws AxisFault {
        return new EndpointReference[]{new EndpointReference(this.getServiceURL(serviceName, transport))};
    }

    public String getServiceURL(String serviceName, String transport) {
        String servicesURL = this.getServicesURL(transport);
        return servicesURL + serviceName;
    }

    public String getServicesURL(String transport) {
        String baseURL = this.getBaseURL(transport);
        String servicesURL = baseURL + this.servicesContext + "/" + this.servicesMapping + "/";
        return servicesURL;
    }

    public void initTransportListenerForAxis(TransportInDescription transprtInDesc, String transport) throws AxisFault {
        Parameter portParam = transprtInDesc.getParameter("port");
        if (portParam == null) {
            int port = this.getPortForTransport(transport);
            portParam = new Parameter("port", (Object)Integer.toString(port));
        }
        transprtInDesc.addParameter(portParam);
        Parameter hostParam = transprtInDesc.getParameter("hostname");
        if (hostParam == null) {
            hostParam = new Parameter("hostname", (Object)this.getHostAddress());
        }
        transprtInDesc.addParameter(hostParam);
    }

    public void addRedirect(String from, String to) {
        if (this.redirects == null) {
            this.redirects = new HashMap();
        }
        this.redirects.put(from, to);
    }

    public String getRedirect(String from) {
        if (this.redirects == null) {
            return null;
        }
        return this.redirects.get(from);
    }

    public void removeRedirect(String from) {
        if (this.redirects != null) {
            this.redirects.remove(from);
        }
    }

    public String getBaseURL() {
        return this.getBaseURL("http");
    }

    public String getBaseURL(String transport) {
        int port = this.getPortForTransport(transport);
        String baseURL = this.host == null || this.host.length() == 0 || this.host.equals("null") ? transport + "://" + this.getHostAddress() + ":" + port + "/" : transport + "://" + this.host + ":" + port + "/";
        return baseURL;
    }

    private int getPortForTransport(String transport) {
        int port;
        if (transport.equals("http")) {
            port = this.httpPort;
        } else if (transport.equals("https")) {
            port = this.httpsPort;
        } else {
            throw new IllegalArgumentException("Transport not supported by the SOAP server.");
        }
        return port;
    }

    public String buildServiceAddress(String transport, String serviceName) {
        StringBuffer sb = new StringBuffer(this.getBaseURL(transport));
        sb.append(this.getServicesContext());
        sb.append('/');
        sb.append(this.getServicesMapping());
        sb.append('/');
        sb.append(serviceName);
        return sb.toString();
    }
}

