/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIOperationDispatcher;
import org.apache.axis2.dispatchers.SOAPActionBasedDispatcher;
import org.apache.axis2.dispatchers.SOAPMessageBodyBasedDispatcher;
import org.apache.axis2.engine.DispatchPhase;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.binding.soap.axis.HandlerConfig;
import org.ow2.petals.binding.soap.axis.PhaseConfig;

public class PhaseConfigTest {
    private static final String PHASE_CONFIG_TEST0 = "PhaseConfigTest0.xml";
    private static final String PHASE_CONFIG_TEST1 = "PhaseConfigTest1.xml";

    @Test
    public void testDumpXmlWithoutImplClass() throws Exception {
        InputStream expected = this.getClass().getClassLoader().getResourceAsStream(PHASE_CONFIG_TEST0);
        HandlerConfig requestURIBasedDispatcherConfig = new HandlerConfig("RequestURIBasedDispatcher", RequestURIBasedDispatcher.class);
        HandlerConfig soapActionBasedDispatcherConfig = new HandlerConfig("SOAPActionBasedDispatcher", SOAPActionBasedDispatcher.class);
        PhaseConfig config = new PhaseConfig("Transport");
        config.addHandler(requestURIBasedDispatcherConfig);
        config.addHandler(soapActionBasedDispatcherConfig);
        StringWriter sw = new StringWriter();
        config.dump((Writer)sw);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)expected, (InputStream)new ByteArrayInputStream(sw.getBuffer().toString().getBytes())));
    }

    @Test
    public void testDumpXmlWithImplClass() throws Exception {
        InputStream expected = this.getClass().getClassLoader().getResourceAsStream(PHASE_CONFIG_TEST1);
        HandlerConfig requestURIOperationDispatcherConfig = new HandlerConfig("RequestURIOperationDispatcher", RequestURIOperationDispatcher.class);
        HandlerConfig soapMessageBodyBasedDispatcherConfig = new HandlerConfig("SOAPMessageBodyBasedDispatcher", SOAPMessageBodyBasedDispatcher.class);
        PhaseConfig config = new PhaseConfig("Dispatch", DispatchPhase.class);
        config.addHandler(requestURIOperationDispatcherConfig);
        config.addHandler(soapMessageBodyBasedDispatcherConfig);
        StringWriter sw = new StringWriter();
        config.dump((Writer)sw);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)expected, (InputStream)new ByteArrayInputStream(sw.getBuffer().toString().getBytes())));
    }
}

