/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.jbi.JBIException;
import javax.jbi.component.InstallationContext;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapBootstrapOperations {
    private final InstallationContext installContext;

    public SoapBootstrapOperations(InstallationContext installContext) {
        this.installContext = installContext;
    }

    public void setParam(String name, String value, Jbi jbi) {
        for (Element element : jbi.getComponent().getAny()) {
            if (!element.getLocalName().equals(name)) continue;
            element.setTextContent(value);
        }
    }

    public String getParam(String name, Jbi jbi) {
        for (Element element : jbi.getComponent().getAny()) {
            if (!element.getLocalName().equals(name)) continue;
            return element.getTextContent();
        }
        return null;
    }

    public String addModule(String str) throws JBIException {
        String result = "Can not add module '" + str + "' to Axis2";
        File file = null;
        try {
            new URL(str);
            URI uri = new URI(str);
            file = new File(uri);
        }
        catch (URISyntaxException e1) {
            throw new JBIException("Bad URI : " + str);
        }
        catch (MalformedURLException e) {
            throw new JBIException("Malformed URL : " + str);
        }
        if (file.exists() && !file.isDirectory()) {
            try {
                this.addModule(file);
                result = "Module '" + str + "' successfully added to Axis2";
            }
            catch (Exception e) {
                result = result + "\n" + e.getMessage();
            }
        }
        return result;
    }

    private void addModule(File moduleFile) throws Exception {
        if (moduleFile == null || !moduleFile.exists()) {
            throw new IllegalArgumentException("Bad module file");
        }
        String workspaceRootDir = this.installContext.getContext().getWorkspaceRoot();
        File modules = new File(workspaceRootDir, "modules");
        File configFile = new File(workspaceRootDir, "axis2.xml");
        String moduleName = moduleFile.getName().substring(0, moduleFile.getName().lastIndexOf(46));
        File destFile = new File(modules, moduleFile.getName());
        if (destFile.exists()) {
            throw new Exception("Module '" + moduleName + "' already exists in destination folder");
        }
        if (moduleFile.exists()) {
            if (!moduleFile.getName().endsWith(".mar")) {
                throw new FileNotFoundException("Module file source does not exists");
            }
        } else {
            throw new FileNotFoundException("Source module does not exists");
        }
        FileUtils.copyFile((File)moduleFile, (File)destFile);
        FileInputStream inputStream = new FileInputStream(configFile);
        Document document = XMLUtil.loadDocument((InputStream)inputStream);
        Element rootElement = document.getDocumentElement();
        Element module = document.createElement("module");
        module.setAttribute("ref", moduleName);
        rootElement.appendChild(module);
        XMLHelper.writeDocument((Document)document, (OutputStream)new FileOutputStream(configFile));
    }
}

