/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ow2.petals.binding.soap.axis.AbstractNamedConfig;
import org.ow2.petals.binding.soap.axis.MessageReceiverConfig;
import org.ow2.petals.binding.soap.axis.PhaseOrderConfig;
import org.ow2.petals.binding.soap.axis.TransportReceiverConfig;
import org.ow2.petals.binding.soap.axis.TransportSenderConfig;

public class Axis2Config
extends AbstractNamedConfig {
    private final Map<String, MessageReceiverConfig> messageReceivers = new LinkedHashMap<String, MessageReceiverConfig>();
    private final Map<String, TransportReceiverConfig> transportReceivers = new LinkedHashMap<String, TransportReceiverConfig>();
    private final Map<String, TransportSenderConfig> transportSenders = new LinkedHashMap<String, TransportSenderConfig>();
    private final Map<String, PhaseOrderConfig> phaseOrders = new LinkedHashMap<String, PhaseOrderConfig>();

    public Axis2Config(String name) {
        super(name);
    }

    @Override
    public void dump(Writer writer) throws IOException {
        writer.write(String.format("<axisconfig name='%s'>\n", this.getName()));
        for (Map.Entry<String, String> entry : this.getParameters().entrySet()) {
            writer.write(String.format("<parameter name='%s'>%s</parameter>\n", entry.getKey(), entry.getValue()));
        }
        writer.write("<messageReceivers>\n");
        for (MessageReceiverConfig messageReceiver : this.messageReceivers.values()) {
            messageReceiver.dump(writer);
        }
        writer.write("</messageReceivers>\n");
        writer.write("<messageFormatters/>\n");
        writer.write("<messageBuilders/>\n");
        for (TransportReceiverConfig transportReceiver : this.transportReceivers.values()) {
            transportReceiver.dump(writer);
        }
        for (TransportSenderConfig transportSender : this.transportSenders.values()) {
            transportSender.dump(writer);
        }
        for (PhaseOrderConfig phaseOrder : this.phaseOrders.values()) {
            phaseOrder.dump(writer);
        }
        writer.write("</axisconfig>");
    }

    public void addMessageReceiver(MessageReceiverConfig messageReceiverConfig) {
        assert (messageReceiverConfig != null);
        this.messageReceivers.put(messageReceiverConfig.getMep(), messageReceiverConfig);
    }

    public void addTransportReceiver(TransportReceiverConfig transportReceiverConfig) {
        assert (transportReceiverConfig != null);
        this.transportReceivers.put(transportReceiverConfig.getName(), transportReceiverConfig);
    }

    public void addTransportSender(TransportSenderConfig transportSenderConfig) {
        assert (transportSenderConfig != null);
        this.transportSenders.put(transportSenderConfig.getName(), transportSenderConfig);
    }

    public void addPhaseOrder(PhaseOrderConfig phaseOrderConfig) {
        assert (phaseOrderConfig != null);
        this.phaseOrders.put(phaseOrderConfig.getName(), phaseOrderConfig);
    }
}

